. $PSScriptRoot\obterStringConexao.ps1
. $PSScriptRoot\configuracoesMicrouniversoWeb.ps1

function global:mu.executarMigrations() {
    param(
        $configuracoes
    )

    $prosseguirComExecucao = $configuracoes.servicos.rest.configurar -or `
        $configuracoes.servicos.authServer.configurar -or `
        $configuracoes.servicos.resourceServer.configurar -or `
        $configuracoes.servicos.segurancaWeb.configurar -or `
        $configuracoes.servicos.imagensProdutos.configurar -or `
        $configuracoes.servicos.orcamentoWeb.configurar -or `
        $configuracoes.servicos.carrinhoDeCompra.configurar -or `
        $configuracoes.servicos.financeiro.configurar -or `
        $configuracoes.servicos.liberarPendencia.configurar -or `
        $configuracoes.enterprise.configurar

    if (-not $prosseguirComExecucao) {
        _echo "Nenhum servico que usa o banco do ERP sera configurado. Migrations nao serao executadas"
        return
    }

    $migrationPath = "$($configuracoes.enderecos.diretorioBaseInstalacao)\migration"
    $migrationsDlls = "$($configuracoes.enderecos.diretorioBaseInstalacao)\migrations"

    $migrateExe = "$migrationPath\Migrate.exe"
    $migrationsDll = "$migrationsDlls\MicroUniverso.Infrastructure.Data.Migrations.dll"
    $stringConexao = mu.obterStringConexao $configuracoes "DOT_NET"

    if (-not (test-path $migrateExe)) {
        _echo "Migrate.exe nao encontrado em $migrateExe. Migrations nao serao executadas" error
        return
    }

    if (-not (test-path $migrationsDll)) {
        _echo "MicroUniverso.Infrastructure.Data.Migrations.dll nao encontrado em $migrationsDll. Migrations nao serao executadas" error
        return
    }


    & $migrateExe /connection $stringConexao /db sqlserver2008 /target $migrationsDll --timeout=600
}

function global:mu.executarMigrations.test() {
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter C:\temp\microuniversoWeb-migrations.yaml

    mu.executarMigrations $configuracoes
}