. $PSScriptRoot\_echo.ps1

function global:mu.executarAjustesParaFenixWrapperSeNecessario() {
    param(
        $configuracoes
    )

    $prosseguir = $configuracoes.servicos.rest.configurar -or `
        $configuracoes.servicos.authServer.configurar -or `
        $configuracoes.servicos.resourceServer.configurar -or `
        $configuracoes.servicos.segurancaWeb.configurar -or `
        $configuracoes.servicos.imagensProdutos.configurar -or `
        $configuracoes.servicos.orcamentoWeb.configurar -or `
        $configuracoes.servicos.financeiro.configurar

    if (-not $prosseguir) {
        _echo "Nenhum servico que usa o FenixWrapper sera configurado. Ajustes nao serao feitos"
        return
    }

    $appcmd = "C:\\windows\\system32\\inetsrv\\appcmd.exe"

    if ($configuracoes.servicos.fenixWrapper.habilitar) {
        if ($configuracoes.servicos.rest.ignorarFenixWrapper -eq $false) {
            & $appcmd set apppool /apppool.name:$($configuracoes.servicos.rest.nomeSite) /processModel.maxprocesses:0
            & $appcmd set apppool /apppool.name:$($configuracoes.servicos.rest.nomeSite) /enable32BitAppOnWin64:$false /startMode:AlwaysRunning /processModel.idleTimeout:00:00:00
        }

        & $appcmd set apppool /apppool.name:$($configuracoes.servicos.orcamentoWeb.nomeSite) /processModel.maxprocesses:1
        & $appcmd set apppool /apppool.name:$($configuracoes.servicos.orcamentoWeb.nomeSite) /enable32BitAppOnWin64:$false /startMode:AlwaysRunning /processModel.idleTimeout:00:00:00

        & $appcmd set config $($configuracoes.servicos.orcamentoWeb.nomeSite) /section:system.webServer/security/requestFiltering /requestLimits.maxAllowedContentLength:40000000
        & $appcmd set config $($configuracoes.servicos.orcamentoWeb.nomeSite) /section:system.webServer/security/requestFiltering /requestLimits.maxQueryString:100000
        & $appcmd set config $($configuracoes.servicos.orcamentoWeb.nomeSite) /section:system.webServer/security/requestFiltering /requestLimits.maxUrl:100000
    }
}