
. $PSScriptRoot\validarComandoAnterior.ps1

function global:mu.copiarDlls() {
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    $prosseguirComCopia = $configuracoes.servicos.rest.configurar -or `
        $configuracoes.servicos.authServer.configurar -or `
        $configuracoes.servicos.resourceServer.configurar -or `
        $configuracoes.servicos.segurancaWeb.configurar -or `
        $configuracoes.servicos.imagensProdutos.configurar -or `
        $configuracoes.servicos.orcamentoWeb.configurar -or `
        $configuracoes.servicos.carrinhoDeCompra.configurar -or `
        $configuracoes.servicos.financeiro.configurar -or `
        $configuracoes.servicos.liberarPendencia.configurar -or `
        $configuracoes.enterprise.configurar

    if (-not $prosseguirComCopia) {
        _echo "Nenhum servico que usa as as DLLS DllInscE32.dll, fenix.dll sera configurado. DLLS nao serao copiadas"
        return
    }

    $pstoolsPath = "$diretorioReleaseWeb\pstools"
    Set-Alias -Name psexec -Value "$(Join-Path -Path $pstoolsPath -ChildPath psexec)"

    $diretorioBaseInstalacao = $configuracoes.enderecos.diretorioBaseInstalacao

    new-item -ItemType Directory -Path "$diretorioBaseInstalacao\dll" -ErrorAction Ignore

    $ErrorActionPreferenceBackup = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'

    Copy-Item "$diretorioReleaseWeb\dll\DllInscE32.dll" "$diretorioBaseInstalacao\dll"
    Copy-Item "$diretorioReleaseWeb\dll\DllInscE32.dll" "C:\windows\System32"
    Copy-Item "$diretorioReleaseWeb\dll\DllInscE32.dll" "C:\windows\SysWOW64"

    $ErrorActionPreference = $ErrorActionPreferenceBackup

    Copy-Item "$diretorioReleaseWeb\dll\fenix.dll" "$diretorioBaseInstalacao\dll"

    & "c:\windows\system32\regsvr32" /s "$diretorioBaseInstalacao\dll\fenix.dll"
    mu.validarComandoAnterior


}