. $PSScriptRoot\obterStringConexao.ps1
. $PSScriptRoot\obterEnderecoHttpServico.ps1
. $PSScriptRoot\obterEnderecoHttpsServico.ps1
. $PSScriptRoot\obterBuildTools.ps1
. $PSScriptRoot\_echo.ps1
. $PSScriptRoot\configuracoesMicrouniversoWeb.ps1
. $PSScriptRoot\obterBuildTools.ps1

function global:_mu.configurarOrcamentoWeb() {
    param(
        $configuracoes,
        $buildTools
    )

    if ($configuracoes.servicos.orcamentoWeb.configurar -eq $false) {
        _echo "OrcamentoWeb desativado via configuracao. Arquivos .config nao serao configurados"
        return
    }

    $diretorioSite = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.orcamentoWeb.diretorioRelativoInstalacao)"

    

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"connectionString"'"]/@value "$(mu.obterStringConexao $configuracoes VFP)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"connectionStringFenixWeb"'"]/@value "$(mu.obterStringConexao $configuracoes DOT_NET)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/connectionStrings/add[@name="'"elmahConexao"'"]/@connectionString "$(mu.obterStringConexao $configuracoes DOT_NET)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"serverBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes authServer)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"resourceBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes resourceServer)" 

    if ($configuracoes.certificado.configurar){
        & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"appBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpsServico $configuracoes segurancaWeb)"
    }
    else{
        & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"appBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes segurancaWeb)"
    }
    if ($configuracoes.certificado.configurar){
        & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"restApiBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpsServico $configuracoes rest)"
    }
    else {
        & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"restApiBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes rest)"
    }

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"fenixDllPath"'"]/@value "$($configuracoes.enderecos.diretorioBaseInstalacao)\dll"

    & $buildTools changexmldata %DEF_PATH%\app\rest\web.config /configuration/fenixConfig/add[@key="'"urlImagensProdutos"'"]/@value "$($configuracoes.enderecos.urlImagensProdutos)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"urlImagensProdutos"'"]/@value "$($configuracoes.enderecos.urlImagensProdutos)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"caminhoBaseImagensProdutos"'"]/@value "$($configuracoes.servicos.imagensProdutos.diretorioAbsolutoInstalacao)"

    # & $buildTools versionnumber $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"versaoAplicacao"'"]/@value %BUILD_NUMBER%

    & $buildTools changexmldata $diretorioSite\web.config /configuration/system.web/sessionState/@timeout "$($configuracoes.timeout)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/hostManager/add[@key="'"maxWcfStandBy"'"]/@value "$($configuracoes.servicos.orcamentoWeb.maximoHostsEmStandBy)"

    & $buildTools changexmldata $diretorioSite\Web.config /configuration/fenixConfig/add[@key="'"usarFenixWrapper"'"]/@value "$($configuracoes.servicos.fenixWrapper.habilitar)".ToLower()

    & $buildTools changexmldata $diretorioSite\Web.config /configuration/microAuth/add[@key="'"desativarExpiracaoDeSessoesAplicativo"'"]/@value "$($configuracoes.servicos.fenixWrapper.habilitar)".ToLower()

    if ($configuracoes.servicos.fenixWrapper.habilitar -eq $true) {
        $fenixWrapperExePath = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.fenixWrapper.diretorioRelativoInstalacao)\FenixWrapper.exe"
        & $buildTools changexmldata $diretorioSite\Web.config /configuration/fenixConfig/add[@key="'"fenixWrapperExePath"'"]/@value "$fenixWrapperExePath"
    }

    & $buildTools changexmldata $diretorioSite\Web.config /configuration/performanceConfig/add[@key="'"logarTemposChamadasEndpoints"'"]/@value "$($configuracoes.performance.ativarLogs)".ToLower()

    & $buildTools changexmldata $diretorioSite\Web.config /configuration/storages/localServer/add[@key="'"isurlrelative"'"]/@value "false"

    if ($configuracoes.certificado.configurar){
        & $buildTools changexmldata $diretorioSite\Web.config /configuration/storages/localServer/add[@key="'"url"'"]/@value "$(_mu.obterEnderecoHttpsServico $configuracoes segurancaWeb)/images"
    }    
    else{
        & $buildTools changexmldata $diretorioSite\Web.config /configuration/storages/localServer/add[@key="'"url"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes segurancaWeb)/images"
    }

    if ($configuracoes.certificado.configurar){
        & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"enterpriseApiBaseAddress"'"]/@value "https://$($configuracoes.servicos.rest.hostEnterprise):$($configuracoes.proxyHttpsLinux.portaEnterprise)"
    }
    else{
        & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"enterpriseApiBaseAddress"'"]/@value "http://$($configuracoes.servicos.rest.hostEnterprise):$($configuracoes.servicos.rest.portaEnterprise)"
    }

}

function global:_mu.configurarFinanceiro() {
    param(
        $configuracoes,
        $buildTools
    )

    if ($configuracoes.servicos.financeiro.configurar -eq $false) {
        _echo "financeiro desativado via configuracao. Arquivos .config nao serao configurados"
        return
    }

    $diretorioSite = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.financeiro.diretorioRelativoInstalacao)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"connectionString"'"]/@value "$(mu.obterStringConexao $configuracoes VFP)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"connectionStringFenixWeb"'"]/@value "$(mu.obterStringConexao $configuracoes DOT_NET)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/connectionStrings/add[@name="'"elmahConexao"'"]/@connectionString "$(mu.obterStringConexao $configuracoes DOT_NET)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"serverBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes authServer)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"resourceBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes resourceServer)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"appBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes segurancaWeb)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"restApiBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes rest)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"financeiroBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes financeiro)"

    # & $buildTools versionnumber $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"versaoAplicacao"'"]/@value %BUILD_NUMBER%

    if ($configuracoes.servicos.fenixWrapper.habilitar -eq $true) {
        $fenixWrapperExePath = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.fenixWrapper.diretorioRelativoInstalacao)\FenixWrapper.exe"
        & $buildTools changexmldata $diretorioSite\Web.config /configuration/fenixConfig/add[@key="'"fenixWrapperExePath"'"]/@value "$fenixWrapperExePath"
    }

}

function global:_mu.configurarSegurancaWeb() {
    param(
        $configuracoes,
        $buildTools
    )

    if ($configuracoes.servicos.segurancaWeb.configurar -eq $false) {
        _echo "segurancaWeb desativado via configuracao. Arquivos .config nao serao configurados"
        return
    }

    $diretorioSite = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.segurancaWeb.diretorioRelativoInstalacao)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"connectionString"'"]/@value "$(mu.obterStringConexao $configuracoes VFP)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"connectionStringFenixWeb"'"]/@value "$(mu.obterStringConexao $configuracoes DOT_NET)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/connectionStrings/add[@name="'"elmahConexao"'"]/@connectionString "$(mu.obterStringConexao $configuracoes DOT_NET)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/storages/template/add[@key="'"baseUrl"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes segurancaWeb)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"serverBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes authServer)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"resourceBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes resourceServer)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"restApiBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes rest)"

    if ($configuracoes.certificado.configurar){
        & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"restApiBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpsServico $configuracoes rest)"
    }
    else{
        & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"restApiBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes rest)"
    }

    if ($configuracoes.certificado.configurar){
        & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"enterpriseApiBaseAddress"'"]/@value "https://$($configuracoes.servicos.rest.hostEnterprise):$($configuracoes.proxyHttpsLinux.portaEnterprise)"
    }
    else{
        & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"enterpriseApiBaseAddress"'"]/@value "http://$($configuracoes.servicos.rest.hostEnterprise):$($configuracoes.servicos.rest.portaEnterprise)"
    }

    

    _echo "Web.config: $($diretorioSite)\web.config"

    & $buildTools changexmldata $diretorioSite\Web.config /configuration/fenixConfig/add[@key="'"usarFenixWrapper"'"]/@value "$($configuracoes.servicos.fenixWrapper.habilitar)".ToLower()

    if ($configuracoes.servicos.fenixWrapper.habilitar -eq $true) {
        $fenixWrapperExePath = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.fenixWrapper.diretorioRelativoInstalacao)\FenixWrapper.exe"
        & $buildTools changexmldata $diretorioSite\Web.config /configuration/fenixConfig/add[@key="'"fenixWrapperExePath"'"]/@value "$fenixWrapperExePath"
    }

    # & $buildTools versionnumber $diretorioSite\web.config /configuration/fenixConfig/add[@key='versaoAplicacao']/@value %BUILD_NUMBER%

}

function global:_mu.configurarRest() {
    param(
        $configuracoes,
        $buildTools
    )

    if ($configuracoes.servicos.rest.configurar -eq $false) {
        _echo "rest desativado via configuracao. Arquivos .config nao serao configurados"
        return
    }

    $diretorioSite = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.rest.diretorioRelativoInstalacao)"
    
    $tamanhoMaximoPaginaWms = $configuracoes.servicos.rest.tamanhoMaximoPaginaWms

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"connectionString"'"]/@value "$(mu.obterStringConexao $configuracoes VFP)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"connectionStringFenixWeb"'"]/@value "$(mu.obterStringConexao $configuracoes DOT_NET)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/connectionStrings/add[@name="'"elmahConexao"'"]/@connectionString "$(mu.obterStringConexao $configuracoes DOT_NET)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"caminhoBaseImagensProdutos"'"]/@value "$($configuracoes.servicos.imagensProdutos.diretorioAbsolutoInstalacao)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/storages/template/add[@key="'"baseUrl"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes segurancaWeb)"

    if ($configuracoes.certificado.configurar){
        & $buildTools changexmldata $diretorioSite\web.config /configuration/storages/template/add[@key="'"baseUrl"'"]/@value "$(_mu.obterEnderecoHttpsServico $configuracoes segurancaWeb)"
    }
    else{
        & $buildTools changexmldata $diretorioSite\web.config /configuration/storages/template/add[@key="'"baseUrl"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes segurancaWeb)"
    }
    
    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"restApi.AreaVendas"'"]/@value ""

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"restApi.Vendedor"'"]/@value ""

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"restApi.Filial"'"]/@value ""

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"restApi.FormaPagamento"'"]/@value ""

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"restApi.TipoDocumento"'"]/@value ""

    # & $buildTools versionnumber $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"versaoAplicacao"'"]/@value %BUILD_NUMBER%

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"restApi.TamanhoMaximoPaginaWMS"'"]/@value "$tamanhoMaximoPaginaWms"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"restApi.CodigoCliente"'"]/@value ""

    & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"serverBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes authServer)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"resourceBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes resourceServer)"

    if ($configuracoes.certificado.configurar){
        & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"appBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpsServico $configuracoes segurancaWeb)"
    }
    else{
        & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"appBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes segurancaWeb)"
    }

    & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"restApiBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes rest)"

    if ($configuracoes.certificado.configurar){
        & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"enterpriseApiBaseAddress"'"]/@value "https://$($configuracoes.servicos.rest.hostEnterprise):$($configuracoes.proxyHttpsLinux.portaEnterprise)"
    }
    else{
        & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"enterpriseApiBaseAddress"'"]/@value "http://$($configuracoes.servicos.rest.hostEnterprise):$($configuracoes.servicos.rest.portaEnterprise)"
    }

    $usarFenixWrapperNoRest = $configuracoes.servicos.fenixWrapper.habilitar -eq $true -and $configuracoes.servicos.rest.ignorarFenixWrapper -eq $false

    & $buildTools changexmldata $diretorioSite\Web.config /configuration/fenixConfig/add[@key="'"usarFenixWrapper"'"]/@value "$usarFenixWrapperNoRest".ToLower()

    if ($usarFenixWrapperNoRest -eq $true) {
        $fenixWrapperExePath = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.fenixWrapper.diretorioRelativoInstalacao)\FenixWrapper.exe"
        & $buildTools changexmldata $diretorioSite\Web.config /configuration/fenixConfig/add[@key="'"fenixWrapperExePath"'"]/@value "$fenixWrapperExePath"
    }

    & $buildTools changexmldata $diretorioSite\Web.config /configuration/performanceConfig/add[@key="'"logarTemposChamadasEndpoints"'"]/@value "$($configuracoes.performance.ativarLogs)".ToLower()

    & $buildTools changexmldata %DEF_PATH%\app\rest\web.config /configuration/fenixConfig/add[@key="'"urlImagensProdutos"'"]/@value "$($configuracoes.enderecos.urlImagensProdutos)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"urlImagensProdutos"'"]/@value "$($configuracoes.enderecos.urlImagensProdutos)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"caminhoBaseImagensProdutos"'"]/@value "$($configuracoes.servicos.imagensProdutos.diretorioAbsolutoInstalacao)"

}

function global:_mu.configurarAuthServer() {
    param(
        $configuracoes,
        $buildTools
    )

    if ($configuracoes.servicos.authServer.configurar -eq $false) {
        _echo "authServer desativado via configuracao. Arquivos .config nao serao configurados"
        return
    }

    $diretorioSite = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.authServer.diretorioRelativoInstalacao)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"connectionString"'"]/@value "$(mu.obterStringConexao $configuracoes VFP)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"connectionStringFenixWeb"'"]/@value "$(mu.obterStringConexao $configuracoes DOT_NET)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/connectionStrings/add[@name="'"elmahConexao"'"]/@connectionString "$(mu.obterStringConexao $configuracoes DOT_NET)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/microAuth/add[@key="'"authServerBaseAddress"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes authServer)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/storages/localServer/add[@key="'"url"'"]/@value "$(_mu.obterEnderecoHttpServico $configuracoes segurancaWeb)/images"

    & $buildTools changexmldata $diretorioSite\Web.config /configuration/fenixConfig/add[@key="'"usarFenixWrapper"'"]/@value "$($configuracoes.servicos.fenixWrapper.habilitar)".ToLower()

    & $buildTools changexmldata $diretorioSite\Web.config /configuration/microAuth/add[@key="'"desativarExpiracaoDeSessoesAplicativo"'"]/@value "$($configuracoes.servicos.fenixWrapper.habilitar)".ToLower()

    if ($configuracoes.servicos.fenixWrapper.habilitar -eq $true) {
        $fenixWrapperExePath = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.fenixWrapper.diretorioRelativoInstalacao)\FenixWrapper.exe"
        & $buildTools changexmldata $diretorioSite\Web.config /configuration/fenixConfig/add[@key="'"fenixWrapperExePath"'"]/@value "$fenixWrapperExePath"
    }

    & $buildTools changexmldata $diretorioSite\Web.config /configuration/performanceConfig/add[@key="'"logarTemposChamadasEndpoints"'"]/@value "$($configuracoes.performance.ativarLogs)".ToLower()

    & $buildTools changexmldata $diretorioSite\Web.config /configuration/appSettings/add[@key="'"executandoAutomacaoWeb"'"]/@value "$($configuracoes.executandoAutomacaoWeb)".ToLower()

}

function global:_mu.configurarResourceServer() {
    param(
        $configuracoes,
        $buildTools
    )

    if ($configuracoes.servicos.resourceServer.configurar -eq $false) {
        _echo "resourceServer desativado via configuracao. Arquivos .config nao serao configurados"
        return
    }

    $diretorioSite = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.resourceServer.diretorioRelativoInstalacao)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"connectionString"'"]/@value "$(mu.obterStringConexao $configuracoes VFP)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/fenixConfig/add[@key="'"connectionStringFenixWeb"'"]/@value "$(mu.obterStringConexao $configuracoes DOT_NET)"

    & $buildTools changexmldata $diretorioSite\web.config /configuration/connectionStrings/add[@name="'"elmahConexao"'"]/@connectionString "$(mu.obterStringConexao $configuracoes DOT_NET)"

}

function global:mu.configurarArquivosWebConfig() {
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    $buildTools = mu.obterBuildTools $configuracoes $diretorioReleaseWeb

    _mu.configurarOrcamentoWeb $configuracoes $buildTools

    _mu.configurarRest $configuracoes $buildTools

    _mu.configurarFinanceiro $configuracoes $buildTools

    _mu.configurarSegurancaWeb $configuracoes $buildTools

    _mu.configurarAuthServer $configuracoes $buildTools

    _mu.configurarResourceServer $configuracoes $buildTools


}
