import-module -name $PSScriptRoot\..\dadosValidacao.psm1
. $PSScriptRoot\..\..\_echo.ps1
. $PSScriptRoot\..\..\criptografiaSenha.ps1

function global:mu.validador.dadosUsuarioValidos() {
    param(
        [Parameter(ValueFromPipeline)]
        $dadosValidacao
    )

    if ($dadosValidacao.configuracaoValida -eq $false) {
        return $dadosValidacao
    }

    $prosseguirComVerificacao = $dadosValidacao.configuracoes.servicos.rest.configurar -or `
        $dadosValidacao.configuracoes.servicos.authServer.configurar -or `
        $dadosValidacao.configuracoes.servicos.resourceServer.configurar -or `
        $dadosValidacao.configuracoes.servicos.segurancaWeb.configurar -or `
        $dadosValidacao.configuracoes.servicos.imagensProdutos.configurar -or `
        $dadosValidacao.configuracoes.servicos.orcamentoWeb.configurar -or `
        $dadosValidacao.configuracoes.servicos.carrinhoDeCompra.configurar -or `
        $dadosValidacao.configuracoes.servicos.financeiro.configurar -or `
        $dadosValidacao.configuracoes.servicos.liberarPendencia.configurar -or `
        $dadosValidacao.configuracoes.centralDeCadastros.configurar -or
        $dadosValidacao.configuracoes.muDllRest.configurar

    if (-not $prosseguirComVerificacao) {
        return $dadosValidacao
    }

    _echo "Verificando dados do usuario"

    $senha = ConvertTo-SecureString (mu.descriptografarSenha $dadosValidacao.configuracoes.acessos.usuarioAdministrador.senha) -AsPlainText -Force
    $usuario = $dadosValidacao.configuracoes.acessos.usuarioAdministrador.usuario

    $cred =  new-object -typename System.Management.Automation.PSCredential -argumentlist $usuario, $senha

    Start-Process whoami -Credential $cred -Wait -WorkingDirectory $PSScriptRoot

    if($? -eq $false) {
        $dadosValidacao.configuracaoValida = $false
        $dadosValidacao.codigoErro = "E0004"
        $dadosValidacao.mensagemErro = "Usuario ou senha informados estao invalidos"
    }

    return $dadosValidacao
}

