const fs = require('fs')
const yaml = require('js-yaml')
const mergeYaml = require('merge-yaml')
const {v4:uuidv4} = require('uuid')

async function updateConfigurationFile({
    currentConfigurationFilePath,
    updatedModelConfigurationFilePath,
    outputFilePath
}) {
    const updatedModelConfiguration = yaml.safeLoad(fs.readFileSync(updatedModelConfigurationFilePath,'utf8'))
    const currentConfiguration = yaml.safeLoad(fs.readFileSync(currentConfigurationFilePath,'utf8'))

    const newerVersion = updatedModelConfiguration.versao
    currentConfiguration.versao = newerVersion

    const updatedConfigurationFilePath = "c:\\temp\\" + uuidv4() + ".yaml"
    
    fs.writeFileSync(
        updatedConfigurationFilePath,
        yaml.safeDump(currentConfiguration),
        {encoding: 'utf8'})

    const mergedYaml = mergeYaml([
        updatedModelConfigurationFilePath,
        updatedConfigurationFilePath])

    fs.writeFileSync(
        outputFilePath,
        yaml.safeDump(mergedYaml),
        {encoding: 'utf8'})
}

module.exports = {
    updateConfigurationFile
}