import sys
from lib.echo import echo
from lib.ClienteLinux import obter_cliente_linux
from lib.obter_configuracoes import obter_configuracoes
from lib.executar_validacoes_servidor_linux import executar_validacoes_servidor_linux
import subprocess

arquivo_configuracao = None if len(sys.argv) < 2 else sys.argv[1]
diretorio_scripts_implantacao = r'c:\microuniversoWeb\scripts_implantacao' if len(sys.argv) < 3 else sys.argv[2]
diretorio_certificados = r'c:\microuniversoWeb\certificados'

configuracoes = obter_configuracoes(arquivo_configuracao)

if not configuracoes:
    echo(f"Falha ao carregar configuracoes do arquivo {arquivo_configuracao}", "error")
    exit(1)

if not configuracoes["acessos"]["servidorLinux"]["configurar"]:
    echo("Dados do servidor linux nao informados. proxyHttpsLinux nao sera configurado")
    exit(0)

if not configuracoes["certificado"]["configurar"]:
    echo(f"Configuracao do proxyHttpsLinux nao sera realizada, pois a configuracao de certificado Https não esta ativa.")
    exit(0)

mensagem_erro = executar_validacoes_servidor_linux(arquivo_configuracao, diretorio_scripts_implantacao)

if mensagem_erro:
    echo(mensagem_erro, "error")
    exit(1)

cliente_linux = obter_cliente_linux(arquivo_configuracao)

usuario = configuracoes['acessos']['servidorLinux']['usuario']
usuario_registro_docker = configuracoes["acessos"]["registroDocker"]["usuario"]
senha_registro_docker = configuracoes["acessos"]["registroDocker"]["senha"]
ip_servidor_linux = configuracoes["acessos"]["servidorLinux"]["host"]

openssl_config = fr"""
[req]
default_bits = 2048
distinguished_name = req_distinguished_name
req_extensions = req_ext
prompt = no

[req_distinguished_name]
countryName = XX
stateOrProvinceName = N/A
localityName = N/A
organizationName = Self-signed certificate
commonName = {ip_servidor_linux}: Linux certificate

[req_ext]
subjectAltName = @alt_names
basicConstraints = CA:FALSE

[alt_names]
IP.1 = {ip_servidor_linux}
"""

with open(fr"{diretorio_certificados}\openssl_linux_csr.cnf", "w") as config_file:
    config_file.write(openssl_config)

openssl_sign_config = fr"""
[v3_ca]
subjectAltName = IP:{ip_servidor_linux}
basicConstraints = CA:FALSE
""" 
with open(fr"{diretorio_certificados}\openssl_sign.cnf", "w") as sign_config_file:
    sign_config_file.write(openssl_sign_config)

cliente_linux.executar_comando(fr'docker login gitlab.microuniverso.com.br:5050 -u {usuario_registro_docker} -p {senha_registro_docker}', disparar_excecao_se_retorno_nao_zero=False)

# Cria pastas necessárias
cliente_linux.executar_comando(f'mkdir -p /home/{usuario}/proxyHttpsLinux')
cliente_linux.executar_comando(f'mkdir -p /home/{usuario}/certificados')

subprocess.run([
    "C:\\Program Files\\Git\\mingw64\\bin\\openssl.exe", "genrsa",
    "-out", fr"{diretorio_certificados}\key_linux.pem", "2048"
], check=True)

subprocess.run([
    "C:\\Program Files\\Git\\mingw64\\bin\\openssl.exe", "req", "-new",
    "-key", fr"{diretorio_certificados}\key_linux.pem",
    "-out", fr"{diretorio_certificados}\linux.csr",
    "-config", fr"{diretorio_certificados}\openssl_linux_csr.cnf"
], check=True)

subprocess.run([
    "C:\\Program Files\\Git\\mingw64\\bin\\openssl.exe", "x509", "-req",
    "-in", fr"{diretorio_certificados}\linux.csr",
    "-CA", fr"{diretorio_certificados}\cert.pem",
    "-CAkey", fr"{diretorio_certificados}\key.pem",
    "-CAcreateserial",
    "-out", fr"{diretorio_certificados}\cert_linux.pem",
    "-days", "36500",
    "-extensions", "v3_ca",
    "-extfile", fr"{diretorio_certificados}\openssl_sign.cnf"
], check=True)

# Copia certificados e compose para Linux
cliente_linux.copiar_arquivo(fr'{diretorio_certificados}\cert_linux.pem', f'/home/{usuario}/certificados/cert.pem')
cliente_linux.copiar_arquivo(fr'{diretorio_certificados}\key_linux.pem', f'/home/{usuario}/certificados/key.pem')
cliente_linux.copiar_arquivo(fr'{diretorio_certificados}\MicroUniverso.pfx', f'/home/{usuario}/certificados/MicroUniverso.pfx')
cliente_linux.copiar_arquivo(fr'{diretorio_scripts_implantacao}\proxyHttpsLinux\docker-compose-proxyHttpsLinux.yml', f'/home/{usuario}/proxyHttpsLinux/docker-compose.yml')

cliente_linux.executar_comando(f'chmod 644 /home/{usuario}/certificados/*.pem')

# Variáveis de ambiente no compose
porta_proxyHttps_Enterprise = configuracoes["proxyHttpsLinux"]["portaEnterprise"]
ip_host_enterprise = configuracoes["servicos"]["rest"]["hostEnterprise"]
porta_enterprise = configuracoes["enterprise"]["porta"]

# Ajusta portas no compose
cliente_linux.executar_comando(fr"sed -i 's,\$PORTA_PROXY_LINUX_ENTERPRISE,{porta_proxyHttps_Enterprise},g' /home/{usuario}/proxyHttpsLinux/docker-compose.yml")
cliente_linux.executar_comando(fr"sed -i 's,\$PORTA_ENTERPRISE,{porta_enterprise},g' /home/{usuario}/proxyHttpsLinux/docker-compose.yml")
cliente_linux.executar_comando(fr"sed -i 's,\$IP_HOST_ENTERPRISE,{ip_host_enterprise},g' /home/{usuario}/proxyHttpsLinux/docker-compose.yml")
cliente_linux.executar_comando(fr"sed -i 's,\${{USUARIO}},{usuario},g' /home/{usuario}/proxyHttpsLinux/docker-compose.yml")

# Atualiza serviço Docker
cliente_linux.executar_comando(fr'docker compose -f /home/{usuario}/proxyHttpsLinux/docker-compose.yml down')
cliente_linux.executar_comando(fr'docker compose -f /home/{usuario}/proxyHttpsLinux/docker-compose.yml pull')
cliente_linux.executar_comando(fr'docker compose -f /home/{usuario}/proxyHttpsLinux/docker-compose.yml up -d')

exit(0)
