from lib.obter_configuracoes import obter_configuracoes
import sys
from lib.echo import echo
from lib.executar_validacoes_servidor_linux import executar_validacoes_servidor_linux
from lib.ClienteLinux import obter_cliente_linux


arquivo_configuracao = None if len(sys.argv) < 2 else sys.argv[1]
diretorio_scripts_implantacao = r'c:\microuniversoWeb\scriptsImplantacao' if len(sys.argv) < 3 else sys.argv[2]

configuracoes = obter_configuracoes(arquivo_configuracao)

if not configuracoes["acessos"]["servidorLinux"]["configurar"]:
    echo("Dados do servidor linux nao informados. Pesquisa e Produtos nao sera configurada")
    exit(0)

if not configuracoes["pesquisaProduto"]["configurar"]:
    echo("Configuracao da pesquisa de produto desativada via configuracao")
    exit(0)

mensagem_erro = executar_validacoes_servidor_linux(arquivo_configuracao, diretorio_scripts_implantacao)    

if mensagem_erro:
    echo(mensagem_erro, "error")
    exit(1)

cliente_linux = obter_cliente_linux(arquivo_configuracao)

usuario = configuracoes['acessos']['servidorLinux']['usuario']

if cliente_linux.executar_comando(f"test ! -d /home/{usuario}/PesquisaProduto", disparar_excecao_se_retorno_nao_zero=False).codigo_retorno == 0:
    cliente_linux.executar_comando(f'mkdir /home/{usuario}/PesquisaProduto')

cliente_linux.copiar_arquivo(fr'{diretorio_scripts_implantacao}\pesquisaProduto\docker-compose-pesquisa-produto.yml' , f'/home/{usuario}/PesquisaProduto/docker-compose.yml')

host = configuracoes["pesquisaProduto"]["api-gateway"]["host"].rstrip("/")
porta = str(configuracoes["pesquisaProduto"]["api-gateway"].get("porta", "")).strip()

if not host.startswith(("http://", "https://")):
    host = f"http://{host}"

if porta and ":" not in host.split("//", 1)[-1]:
    host = f"{host}:{porta}"

url_api_gateway = host

versao = configuracoes["pesquisaProduto"]["versao"]
usuario_registro_docker = configuracoes["acessos"]["registroDocker"]["usuario"]
senha_registro_docker = configuracoes["acessos"]["registroDocker"]["senha"]


cliente_linux.executar_comando(fr'docker login gitlab.microuniverso.com.br:5050 -u {usuario_registro_docker} -p {senha_registro_docker}', disparar_excecao_se_retorno_nao_zero=False)

cliente_linux.executar_comando(fr"sed -i 's,\$URL_API_GATEWAY,{url_api_gateway},g' /home/{usuario}/PesquisaProduto/docker-compose.yml")
cliente_linux.executar_comando(fr"sed -i 's,\$VERSAO_PESQUISA_PRODUTO,{versao},g' /home/{usuario}/PesquisaProduto/docker-compose.yml")

cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/PesquisaProduto/docker-compose.yml down')    
cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/PesquisaProduto/docker-compose.yml up -d')    

exit(0)

