import sys
from lib.obter_configuracoes import obter_configuracoes
from lib.echo import echo
from lib.cassini_lib import CassiniLib
from lib.criptografia_senha import descriptografar
from lib.executar_validacoes_servidor_linux import executar_validacoes_servidor_linux
from lib.ClienteLinux import obter_cliente_linux


arquivo_configuracao = None if len(sys.argv) < 2 else sys.argv[1]
diretorio_scripts_implantacao = r'c:\microuniversoWeb\scriptsImplantacao' if len(sys.argv) < 3 else sys.argv[2]

configuracoes = obter_configuracoes(arquivo_configuracao)

if not configuracoes:
    echo(f"Falha ao carregar configuracoes do arquivo {arquivo_configuracao}" , "error")
    exit(1)

if not configuracoes["acessos"]["servidorLinux"]["configurar"]:
    echo("Dados do servidor linux nao informados. Cassini nao sera configurado")
    exit(0)

if not configuracoes["cassini"]["configurar"]:
    echo("Configuracao do Cassini desativada via configuracao")
    exit(0)

mensagem_erro = executar_validacoes_servidor_linux(arquivo_configuracao, diretorio_scripts_implantacao)   

if mensagem_erro:
    echo(mensagem_erro, "error")
    exit(1)

cassini_lib = CassiniLib(
    dadosBanco={
        'host': configuracoes['acessos']['banco']['host'],
        'usuario': configuracoes['acessos']['banco']['usuario'],
        'senha': descriptografar(configuracoes['acessos']['banco']['senha']),
        'nomeBanco': configuracoes['acessos']['banco']['nomeBanco']
    },
    endereco_sp_whoisactive_sql=fr'{diretorio_scripts_implantacao}\cassini\sp_WhoIsActive.sql'
)

if not cassini_lib.whoisactive_existe():
    echo ("Criando sp_whoisactive")
    cassini_lib.criar_sp_whoisactive()
else:
    echo ("sp_whoisactive já existe")

echo ("Verificando se usuario atual consegue executar sp_whoisactive")
cassini_lib.executar_whoisactive()

cliente_linux = obter_cliente_linux(arquivo_configuracao)

host_banco = configuracoes['acessos']['banco']['host']
usuario_banco = configuracoes['acessos']['banco']['usuario']
senha_banco = descriptografar(configuracoes['acessos']['banco']['senha'])
nome_banco = configuracoes['acessos']['banco']['nomeBanco']
usuario_registro_docker = configuracoes["acessos"]["registroDocker"]["usuario"]
senha_registro_docker = configuracoes["acessos"]["registroDocker"]["senha"]
usuario = configuracoes['acessos']['servidorLinux']['usuario']    

cliente_linux.executar_comando(f"mkdir -p /home/{usuario}/cassini")

cliente_linux.copiar_arquivo(fr'{diretorio_scripts_implantacao}\cassini\docker-compose-cassini.yml' , f'/home/{usuario}/cassini/docker-compose.yml')

cliente_linux.executar_comando(fr'docker login gitlab.microuniverso.com.br:5050 -u {usuario_registro_docker} -p {senha_registro_docker}', disparar_excecao_se_retorno_nao_zero=False)

cliente_linux.executar_comando(fr"sed -i 's,\$VERSAO,latest,g' /home/{usuario}/cassini/docker-compose.yml")
host_banco_ajustado = host_banco.replace("\\","\\\\")
cliente_linux.executar_comando(fr"sed -i 's,\$HOST_BANCO,{host_banco_ajustado},g' /home/{usuario}/cassini/docker-compose.yml")
cliente_linux.executar_comando(fr"sed -i 's,\$USUARIO_BANCO,{usuario_banco},g' /home/{usuario}/cassini/docker-compose.yml")
cliente_linux.executar_comando(fr"sed -i 's,\$SENHA_BANCO,{senha_banco},g' /home/{usuario}/cassini/docker-compose.yml", echoar=False, descricao="Alterando senha do banco")
cliente_linux.executar_comando(fr"sed -i 's,\$NOME_BANCO,{nome_banco},g' /home/{usuario}/cassini/docker-compose.yml")

cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/cassini/docker-compose.yml down')    
cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/cassini/docker-compose.yml pull')    
cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/cassini/docker-compose.yml up -d')    

exit(0)    