const axios = require('axios').default
const expect = require('chai').expect
const semver = require('semver')
const argv = require('process').argv

async function obterNumeroPaginas(token) {
    const resposta = (await axios.get(`https://gitlab.microuniverso.com.br/api/v4/projects/110/registry/repositories/20/tags`,{
        headers: {
            'PRIVATE-TOKEN': token
        }
    }))

    return resposta.headers['x-total-pages']
}

async function listarPorPagina(pagina, token) {
    const resposta = (await axios.get(`https://gitlab.microuniverso.com.br/api/v4/projects/110/registry/repositories/20/tags?page=${pagina}`,{
        headers: {
            'PRIVATE-TOKEN': token
        }
    }))

    return resposta.data
}

function obterListaDeVersoesParaApresentacao(listaImagensETags) {
    return listaImagensETags.map(e => e.name).join("\n")
}

async function main() {
    const token = argv.length >= 3 ? argv[2] : null

    if (token == null) {
        console.error('token nao informado')
        return
    }

    const numeroPaginas = await obterNumeroPaginas(token)


    let listaImagensETags = []
    

    for (let pagina = 1 ; pagina <= numeroPaginas ; pagina++) {
        listaImagensETags = [
            ...listaImagensETags,
            ...(await listarPorPagina(pagina,token))
        ]
    }

    return obterListaDeVersoesParaApresentacao(listaImagensETags)
}

main().then(lista => {
    if (lista != null) {
        console.log(lista)
    }
})
