. $PSScriptRoot\backupArquivos.ps1
. $PSScriptRoot\configuracoesMicrouniversoWeb.ps1
. $PSScriptRoot\validarComandoAnterior.ps1
. $PSScriptRoot\releaseWebUtils.ps1
. $PSScriptRoot\copiarServicosParaDiretorioInstalacao.ps1
. $PSScriptRoot\configurarSitesEPools.ps1
. $PSScriptRoot\configurarArquivosWebConfig.ps1
. $PSScriptRoot\configurarApps.ps1
. $PSScriptRoot\copiarDlls.ps1
. $PSScriptRoot\configurarWcf.ps1
. $PSScriptRoot\executarMigrations.ps1
. $PSScriptRoot\backupMicrouniversoWeb.ps1
. $PSScriptRoot\validacoes\executarValidacoes.ps1
. $PSScriptRoot\configurarEnterprise.ps1
. $PSScriptRoot\configurarMuDllRest.ps1
. $PSScriptRoot\configurarCentralDeCadastros.ps1
. $PSScriptRoot\copiarMigrations.ps1
. $PSScriptRoot\pararProcessosEServicosNecessarios.ps1
. $PSScriptRoot\adicionarRegrasFirewall.ps1
. $PSScriptRoot\executarAjustesParaFenixWrapperSeNecessario.ps1
. $PSScriptRoot\instalarRecursoWebSockets.ps1
. $PSScriptRoot\configurarMonitorWMS.ps1
. $PSScriptRoot\configurarMonitorFreteRapido.ps1
. $PSScriptRoot\configurarMonitorFreteRapidoDocker.ps1
. $PSScriptRoot\configurarMicrokafka.ps1
. $PSScriptRoot\configurarOrcamentoWebParaLoadBalancerAWS.ps1
. $PSScriptRoot\configurarWhatsappBot.ps1
. $PSScriptRoot\executarScriptPython.ps1



function global:_mu.confirmarContinuacaoSeNecessario() {
    param(
        $suprimirConfirmacoes
    )

    if ($suprimirConfirmacoes) {
        return
    }

    _echo "Continuar (S/n)?"
    $teclaPressionada = [System.Console]::ReadLine()

    if ($teclaPressionada.ToUpper() -eq "S" -or $teclaPressionada -eq "") {
        return
    }
    else {
        exit 0
    }
}

function global:mu.executarInstalacao() {
    param(
        [Parameter(Mandatory = $true)]
        [string]
        $enderecoArquivoConfiguracao,

        [Parameter(Mandatory = $true)]
        [bool]
        $suprimirConfirmacoes,

        [Parameter(Mandatory = $false)]
        $enderecoChavePublica,

        [Parameter(Mandatory = $false)]
        $senha,

        [Parameter(Mandatory = $false)]
        $referencia,

        [Parameter(Mandatory = $false)]
        $diretorioReleaseWeb
    )



    $python = "c:\microuniversoWeb\python\python.exe"

    _echo "Carregando configuracoes"

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $enderecoArquivoConfiguracao -senha $senha

    _echo "Configuracoes carregadas"

    $configuracoes.dadosRelease.referencia = if ($PSBoundParameters.ContainsKey("referencia") -and $null -ne $referencia) {
        $referencia
    } else {
        $configuracoes.dadosRelease.referencia
    }

    _echo "Executando validacoes"

    mu.executarValidacoes $configuracoes

    _echo "Validacoes executadas"


    mu.pararProcessosEServicosNecessarios $configuracoes

    _echo "Processos e servicos parados"

    if ($configuracoes.muDllRest.configurar -eq $true) {
        _echo "Parando servico MuDllRest"
        cmd /c sc stop MuDllRest
    }



    $diretorioBackupMicrouniversoWeb = mu.backupMicrouniversoWeb.obterDiretorioBackup
    _echo "Fazendo backup do diretorio C:\microuniversoWeb em $diretorioBackupMicrouniversoWeb"
    _echo "ATENCAO: OS BACKUPS SAO FEITOS EM C:\backupsMicrouniversoWeb"
    _echo "ESTA PASTA PODE AUMENTAR DE TAMANHO MUITO RAPIDAMENTE. REMOVA BACKUPS ANTIGOS SE NECESSARIO"
    mu.backupMicrouniversoWeb.fazerBackup $configuracoes $diretorioBackupMicrouniversoWeb
    _echo "Backup de C:\microuniversoWeb concluido"


    _echo "Clonando repositorio ReleaseWeb em $($configuracoes.dadosRelease.referencia)"
    $diretorioReleaseWeb = mu.clonarReleaseWeb -configuracoes $configuracoes -diretorioReleaseWeb $diretorioReleaseWeb


    _echo "Fazendo backup dos arquivos"
    mu.fazerBackupArquivos $configuracoes

    _echo "Copiando servicos para diretorio de instalacao"
    mu.copiarServicosParaDiretorioInstalacao $configuracoes $diretorioReleaseWeb $enderecoArquivoConfiguracao



    _echo "Configurando sites e pools"
    mu.configurarSitesEPools $configuracoes $diretorioReleaseWeb



    _echo "Configurando arquivos web.config"
    mu.configurarArquivosWebConfig $configuracoes $diretorioReleaseWeb



    _echo "Configurando apps"
    mu.configurarApps $configuracoes $diretorioReleaseWeb

    _echo "Executando ajustes nos pools devido ao FenixWrapper se necessario"
    mu.executarAjustesParaFenixWrapperSeNecessario $configuracoes



    _echo "Copiando e registrando DLLs"
    mu.copiarDlls $configuracoes $diretorioReleaseWeb


    _echo "Enterprise"


        $diretorioScriptsImplantacao = $psscriptroot



        $exitCode = mu.executarScriptPython -script "$psscriptroot\scriptsPython\configurar_api_enterprise.py" -argumentos "$enderecoArquivoConfiguracao $diretorioScriptsImplantacao"


        if ($exitCode -ne 0) {
            _echo "exitCode Enterprise: $LastExitCode"
            exit $exitCode
        }


    _echo "Microkafka"

        $diretorioScriptsImplantacao = $psscriptroot



        $exitCode = mu.executarScriptPython -script "$psscriptroot\scriptsPython\configurar_microkafka.py" -argumentos "$enderecoArquivoConfiguracao $diretorioScriptsImplantacao"

        if ($exitCode -ne 0) {
            _echo "exitCode Microkafka: $LastExitCode"
            exit $exitCode
        }




    _echo "MuDllRest"

    mu.muDllRest.configurarMuDllRest $configuracoes $enderecoArquivoConfiguracao $diretorioScriptsImplantacao

    _echo "CentralDeCadastros"
        $diretorioScriptsImplantacao = $psscriptroot

        $exitCode = mu.executarScriptPython -script "$psscriptroot\scriptsPython\configurar_central_de_cadastros.py" -argumentos "$enderecoArquivoConfiguracao $diretorioScriptsImplantacao"

        if ($exitCode -ne 0) {
            _echo "exitCode Central De Cadastros: $LastExitCode"
            exit $exitCode
        }

    _echo "API Gateway"

        $diretorioScriptsImplantacao = $psscriptroot

        $exitCode = mu.executarScriptPython -script "$psscriptroot\scriptsPython\configurar_api_gateway.py" -argumentos "$enderecoArquivoConfiguracao $diretorioScriptsImplantacao"

        if ($exitCode -ne 0) {
            _echo "exitCode API Gateway: $LastExitCode"
            exit $exitCode
        }

    _echo "Copiando migrations"
    mu.copiarMigrations $configuracoes $diretorioReleaseWeb
    _echo "Migrations copiadas"

    _echo "Executando migrations"
    mu.executarMigrations $configuracoes

    _echo "Configurando Vendas para operar em Load Balancer da AWS"
    mu.configurarOrcamentoWebParaLoadBalancerAWS.executar $configuracoes


    _echo "Restaurando ultimo backup"
    mu.restaurarBackupArquivos $configuracoes
    _echo "Restauracao de backup concluida"



    _echo "Adicionando regras de firewall"
    mu.adicionarRegrasFirewall $configuracoes


    $referenciaReleaseWeb = mu.obterTagOuSHA1ReleaseWeb -enderecoRepositorio $diretorioReleaseWeb


    $configuracoesAtualizadas = mu.configuracoesMicrouniversoWeb.atualizarHistoricoInstalacoes  -configuracoes $configuracoes `
                                                                                                -referencia $referenciaReleaseWeb

    mu.configuracoesMicrouniversoWeb.salvar -configuracoes $configuracoesAtualizadas `
                                            -enderecoYaml $enderecoArquivoConfiguracao `
                                            -senha $senha `
                                            -enderecoChavePublica $enderecoChavePublica `
                                            -excluirArquivoLimpo ($null -ne $senha)

    if (mu.executarInstalacao.iniciarIISQuandoTerminar $configuracoes) {
        _echo "Iniciando IIS"
        iisreset /start
    } else {
        _echo "Nenhum servico que usa o IIS foi configurado. IIS nao sera iniciado"
    }


    _echo "MonitorWMS"
    mu.monitorWMS.configurarMonitorWMS $configuracoes

    _echo "MonitorFreteRapido"
    mu.monitorFreteRapidoDocker.configurarMonitorFreteRapido $configuracoes

    _echo "whatsappBot"
    mu.whatsappBot.configurarWhatsappBot $configuracoes

    _echo "Intercompany"

    $diretorioScriptsImplantacao = $psscriptroot

    $exitCode = mu.executarScriptPython -script "$psscriptroot\scriptsPython\configurar_intercompany.py" -argumentos "$enderecoArquivoConfiguracao $diretorioScriptsImplantacao"

    if ($exitCode -ne 0) {
        _echo "exitCode Intercompany: $LastExitCode"
        exit $exitCode
    }

    _echo "Coleta Preco"

    $diretorioScriptsImplantacao = $psscriptroot

    $exitCode = mu.executarScriptPython -script "$psscriptroot\scriptsPython\configurar_coleta_preco.py" -argumentos "$enderecoArquivoConfiguracao $diretorioScriptsImplantacao"

    if ($exitCode -ne 0) {
        _echo "exitCode Coleta Preco: $LastExitCode"
        exit $exitCode
    }


    _echo "Cassini"

        $diretorioScriptsImplantacao = $psscriptroot

        $exitCode = mu.executarScriptPython -script "$psscriptroot\scriptsPython\configurar_cassini.py" -argumentos "$enderecoArquivoConfiguracao $diretorioScriptsImplantacao"

        if ($exitCode -ne 0) {
            _echo "exitCode Cassini: $LastExitCode"
            exit $exitCode
        }




    _echo "Storybooks"

        _echo "Storybook do Vendas"

        $diretorioScriptsImplantacao = $psscriptroot

        $exitCode = mu.executarScriptPython -script "$psscriptroot\scriptsPython\configurar_storybook_vendas.py" -argumentos "$enderecoArquivoConfiguracao $diretorioScriptsImplantacao"

        if ($exitCode -ne 0) {
            _echo "exitCode Storybook do Vendas: $LastExitCode"
            exit $exitCode
        }

        _echo "Storybook da Central de Cadastros"

        $diretorioScriptsImplantacao = $psscriptroot

        $exitCode = mu.executarScriptPython -script "$psscriptroot\scriptsPython\configurar_storybook_central_de_cadastros.py" -argumentos "$enderecoArquivoConfiguracao $diretorioScriptsImplantacao"

        if ($exitCode -ne 0) {
            _echo "exitCode Storybook da Central de Cadastros: $LastExitCode"
            exit $exitCode
        }

      
        _echo "Pesquisa De Produto"

        $diretorioScriptsImplantacao = $psscriptroot

        $exitCode = mu.executarScriptPython -script "$psscriptroot\scriptsPython\configurar_pesquisa_de_produto.py" -argumentos "$enderecoArquivoConfiguracao $diretorioScriptsImplantacao"

        if ($exitCode -ne 0) {
            _echo "exitCode Pesquisa De Produto: $LastExitCode"
            exit $exitCode
        }

        _echo "Storybook da Central da Pesquisa de Produto"

        $diretorioScriptsImplantacao = $psscriptroot

        $exitCode = mu.executarScriptPython -script "$psscriptroot\scriptsPython\configurar_storybook_pesquisa_de_produto.py" -argumentos "$enderecoArquivoConfiguracao $diretorioScriptsImplantacao"

        if ($exitCode -ne 0) {
            _echo "exitCode Storybook da Pesquisa de Produtos: $LastExitCode"
            exit $exitCode
        }


        _echo "Storybook Intercompany"

        $diretorioScriptsImplantacao = $psscriptroot

        $exitCode = mu.executarScriptPython -script "$psscriptroot\scriptsPython\configurar_storybook_intercompany.py" -argumentos "$enderecoArquivoConfiguracao $diretorioScriptsImplantacao"

        if ($exitCode -ne 0) {
            _echo "exitCode Storybook Intercompany: $LastExitCode"
            exit $exitCode
        }


        _echo "Central de Relatorios"

        $diretorioScriptsImplantacao = $psscriptroot

        $exitCode = mu.executarScriptPython -script "$psscriptroot\scriptsPython\configurar_central_de_relatorios.py" -argumentos "$enderecoArquivoConfiguracao $diretorioScriptsImplantacao"

        if ($exitCode -ne 0) {
            _echo "exitCode Central de Relatorios: $LastExitCode"
            exit $exitCode
        }

        _echo "Storybook da Central de Relatorios"

        $diretorioScriptsImplantacao = $psscriptroot

        $exitCode = mu.executarScriptPython -script "$psscriptroot\scriptsPython\configurar_storybook_central_de_relatorios.py" -argumentos "$enderecoArquivoConfiguracao $diretorioScriptsImplantacao"

        if ($exitCode -ne 0) {
            _echo "exitCode Storybook da Central de Relatorios: $LastExitCode"
            exit $exitCode
        }



        _echo "Api MuWhatsapp"

        $diretorioScriptsImplantacao = $psscriptroot

        $exitCode = mu.executarScriptPython -script "$psscriptroot\scriptsPython\configurar_mu_whatsapp_api.py" -argumentos "$enderecoArquivoConfiguracao $diretorioScriptsImplantacao"

        if ($exitCode -ne 0) {
            _echo "exitCode Central de Relatorios: $LastExitCode"
            exit $exitCode
        }

        _echo "Proxy Https Linux"

        $diretorioScriptsImplantacao = $psscriptroot

        $exitCode = mu.executarScriptPython -script "$psscriptroot\scriptsPython\configurar_proxyHttpsLinux.py" -argumentos "$enderecoArquivoConfiguracao $diretorioScriptsImplantacao"

        if ($exitCode -ne 0) {
            _echo "exitCode Proxy Https Linux: $LastExitCode"
            exit $exitCode
        }

        $exitCode = mu.executarScriptPython -script "$psscriptroot\scriptsPython\configurar_configuracoes_web.py" -argumentos "$enderecoArquivoConfiguracao $diretorioScriptsImplantacao"

        if ($exitCode -ne 0) {
            _echo "exitCode Configuracoes Web: $LastExitCode"
            exit $exitCode
        }
        
        _echo "FIM"


}

function global:mu.executarInstalacao.iniciarIISQuandoTerminar() {
    param(
        $configuracoes
    )

    return $configuracoes.servicos.rest.configurar -or `
        $configuracoes.servicos.authServer.configurar -or `
        $configuracoes.servicos.resourceServer.configurar -or `
        $configuracoes.servicos.segurancaWeb.configurar -or `
        $configuracoes.servicos.imagensProdutos.configurar -or `
        $configuracoes.servicos.orcamentoWeb.configurar -or `
        $configuracoes.servicos.carrinhoDeCompra.configurar -or `
        $configuracoes.servicos.financeiro.configurar -or `
        $configuracoes.servicos.ordemDeCompra.configurar -or `
        $configuracoes.servicos.liberarPendencia.configurar
}

function global:mu.executarInstalacao.test() {
    $ErrorActionPreference = 'Stop'

    $enderecoArquivoConfiguracao = "C:\microuniversoWeb\microuniversoWeb.yaml"
    $senha = "123"
    $enderecoChavePublica = "C:\TrabalhoWeb\ScriptsDeploy\scripts_implantacao\microuniverso.pubkey"

    mu.executarInstalacao   -enderecoArquivoConfiguracao $enderecoArquivoConfiguracao `
                            -suprimirConfirmacoes $true `
                            -enderecoChavePublica $enderecoChavePublica `
                            -senha $senha
}

