const axios = require('axios').default
const expect = require('chai').expect
const semver = require('semver')
const argv = require('process').argv

async function obterNumeroPaginas(token) {
    const resposta = (await axios.get(`https://gitlab.microuniverso.com.br/api/v4/projects/49/registry/repositories/5/tags`,{
        headers: {
            'PRIVATE-TOKEN': token
        }
    }))

    return resposta.headers['x-total-pages']
}

async function listarPorPagina(pagina, token) {
    const resposta = (await axios.get(`https://gitlab.microuniverso.com.br/api/v4/projects/49/registry/repositories/5/tags?page=${pagina}`,{
        headers: {
            'PRIVATE-TOKEN': token
        }
    }))

    return resposta.data
}

function processarSaida(listaImagensETags) {

}

function ehVersaoDeProducao(versao) {
    return new RegExp(/^\d+\.\d+\.\d+-?/).test(versao)
}

function ehVersaoDeProducao_test() {
    expect(ehVersaoDeProducao("1.4.2-windows-2016")).true
    expect(ehVersaoDeProducao("FNX-5220-windows")).false

    console.log('passou')
}

function extrairNumeroDeVersao(versao) {
    const match = versao.match(/^\d+\.\d+\.\d+/)

    return match == null ? "" : match[0]

}

function extrairNumeroDeVersao_test() {
    expect(extrairNumeroDeVersao("1.4.2-windows-2016")).to.equal("1.4.2")
    expect(extrairNumeroDeVersao("1.4.2-linux")).to.equal("1.4.2")
    expect(extrairNumeroDeVersao("FNX-5220-windows")).null

    console.log('passou')

}

function nuloOuVazio(v) {
    return v === undefined || v === null || v == ""
}

function compararVersoes(v1,v2) {
    return  nuloOuVazio(v1) || nuloOuVazio(v2) ? 0 :
            ehVersaoDeProducao(v1) && !ehVersaoDeProducao(v2) ? 1 :
            ehVersaoDeProducao(v2) && !ehVersaoDeProducao(v1) ? -1 :
            ehVersaoDeProducao(v1) && ehVersaoDeProducao(v2) ? (semver.compare(extrairNumeroDeVersao(v1), extrairNumeroDeVersao(v2))) :
            v1.localeCompare(v2)
}

function compararVersoes_test() {
    expect(compararVersoes("1.4.2-windows-2016", "FNX-5220-windows")).to.equal(1)
    expect(compararVersoes("FNX-5220-windows","1.4.2-windows-2016")).to.equal(-1)
    expect(compararVersoes("1.5.0-linux","1.4.2-linux")).to.equal(1)
    expect(compararVersoes("1.4.2-linux","1.5.0-linux")).to.equal(-1)
    expect(compararVersoes("FNX-5220-windows","FNX-5320-windows")).to.equal(-1)
    expect(compararVersoes(null,"1.5.0-linux")).to.equal(0)
    expect(compararVersoes(null,null)).to.equal(0)
    expect(compararVersoes(null,"")).to.equal(0)

    console.log('passou')
}

function ordenarListaImagensETags(listaImagensETags) {
    listaImagensETags.sort((elemento1, elemento2) => compararVersoes(elemento1.name, elemento2.name))

    listaImagensETags.reverse()

    return listaImagensETags
}

function ordenarListaImagensETags_test() {
    const listaImagensETagsTeste = require('./listaImagensETagsTeste.json')

    console.log(ordenarListaImagensETags(listaImagensETagsTeste))
}

function obterListaDeVersoesParaApresentacao(listaImagensETags) {
    return ordenarListaImagensETags(listaImagensETags).map(e => e.name).join("\n")
}

function obterListaDeVersoesParaApresentacao_test() {
    const listaImagensETagsTeste = require('./listaImagensETagsTeste.json')

    console.log(obterListaDeVersoesParaApresentacao(listaImagensETagsTeste))
}

async function main() {
    const token = argv.length >= 3 ? argv[2] : null

    if (token == null) {
        console.error('token nao informado')
        return
    }

    const numeroPaginas = await obterNumeroPaginas(token)

    let listaImagensETags = []

    for (let pagina = 1 ; pagina <= numeroPaginas ; pagina++) {
        listaImagensETags = [
            ...listaImagensETags,
            ...(await listarPorPagina(pagina,token))
        ]
    }

    return obterListaDeVersoesParaApresentacao(listaImagensETags)
}

// listarTodas().then(n => console.log(JSON.stringify(n)))

// obterListaDeVersoesParaApresentacao_test()

main().then(lista => {
    if (lista != null) {
        console.log(lista)
    }
})

// console.log('foo')