. $PSScriptRoot\..\_echo.ps1

function global:mu.criptografarArquivoConfiguracaoUsandoSenha() {
    param(

        [Parameter(Mandatory = $true)]
        $enderecoArquivoLimpo,
        [Parameter(Mandatory = $true)]
        $enderecoArquivoCriptografado,
        [Parameter(Mandatory = $true)]
        $senha,
        [Parameter(Mandatory = $true)]
        $excluirArquivoLimpo
    )

    npm run --prefix $PSScriptRoot\..\ encryptDecryptUsingPassword -- --mode encrypt --source $enderecoArquivoLimpo --destination $enderecoArquivoCriptografado --password $senha | out-null

    if ($excluirArquivoLimpo -eq $true) {
        Remove-Item $enderecoArquivoLimpo
    }
}

function global:mu.criptografarArquivoConfiguracaoUsandoChavePublica() {
    param(
        $enderecoArquivoLimpo,
        $enderecoArquivoCriptografado,
        $enderecoChavePublica,
        $excluirArquivoLimpo
    )

    npm run --prefix $PSScriptRoot\..\ encryptUsingPublicKey -- --publicKeyPath $enderecoChavePublica --source $enderecoArquivoLimpo --destination $enderecoArquivoCriptografado

    if ($excluirArquivoLimpo -eq $true) {
        Remove-Item $enderecoArquivoLimpo
    }
}

function global:mu.decriptografarArquivoConfiguracaoUsandoChavePrivada() {
    param(
        $enderecoArquivoCriptografado,
        $enderecoArquivoDecriptografado,
        $enderecoChavePrivada,
        $senhaChavePrivada
    )

    npm run --prefix $PSScriptRoot\..\ decryptUsingPrivateKey -- --privateKeyPath $enderecoChavePrivada --source $enderecoArquivoCriptografado --destination $enderecoArquivoDecriptografado --privateKeyPassword $senhaChavePrivada
}

function global:mu.decriptografarArquivoConfiguracaoUsandoSenha() {
    param(
        $enderecoArquivoCriptografado,
        $enderecoArquivoDecriptografado,
        $senha
    )

    npm run --silent --prefix $PSScriptRoot\..\ encryptDecryptUsingPassword -- --mode decrypt --source $enderecoArquivoCriptografado --destination $enderecoArquivoDecriptografado --password $senha | out-null

    return $?

}


function global:mu.decriptografarMasterKeyMu() {
    param(
        $senha
        )
        
        $masterKeyMu = npm run --silent --prefix $PSScriptRoot\..\ decriptografar-master-key-mu -- --password $senha
        
        return $masterKeyMu
    }
    
    
    ## TESTES ##
    
function global:mu.decriptografarArquivoConfiguracaoUsandoSenha.test.senhaCorreta() {
    $enderecoArquivoDecriptografado = "C:\microuniversoWeb\microuniversoWeb.yaml.denc"
    $enderecoArquivoCriptografado = "C:\microuniversoWeb\microuniversoWeb.yaml.enc"
    $senha = "1234"

    mu.decriptografarArquivoConfiguracaoUsandoSenha     -enderecoArquivoCriptografado $enderecoArquivoCriptografado `
                                                        -enderecoArquivoDecriptografado $enderecoArquivoDecriptografado `
                                                        -senha $senha

    

}

function global:mu.decriptografarArquivoConfiguracaoUsandoSenha.test.senhaErrada() {
    $enderecoArquivoLimpo = "C:\microuniversoWeb\microuniversoWeb.yaml"
    $enderecoArquivoCriptografado = "C:\microuniversoWeb\microuniversoWeb.yaml.enc"
    $senha = "errada"

    $resultado = mu.decriptografarArquivoConfiguracaoUsandoSenha $enderecoArquivoCriptografado $enderecoArquivoLimpo $senha

    _echo "resultado = $resultado"

    if ($resultado -ne $false) {
        throw "resultado deveria ser false"
    }

}
function global:mu.decriptografarMasterKeyMu.test() {
    mu.decriptografarMasterKeyMu -senha "senhadamu"
}
function global:mu.criptografarArquivoConfiguracaoUsandoSenha.test() {
    $enderecoArquivoLimpo = "C:\microuniversoWeb\microuniversoWeb.yaml"
    $enderecoArquivoCriptografado = "C:\microuniversoWeb\microuniversoWeb.yaml.enc"
    $senha = "1234"

    mu.criptografarArquivoConfiguracaoUsandoSenha -enderecoArquivoLimpo $enderecoArquivoLimpo `
                                        -enderecoArquivoCriptografado $enderecoArquivoCriptografado `
                                        -senha $senha `
                                        -excluirArquivoLimpo $false

}



function global:mu.criptografarArquivoConfiguracaoUsandoChavePublica.test() {
    $enderecoArquivoLimpo = "C:\microuniversoWeb\microuniversoWeb.yaml"
    $enderecoArquivoCriptografado = "C:\microuniversoWeb\microuniversoWeb.yaml.encm"
    $enderecoChavePublica = "C:\mu-scripts\scripts_implantacao\encriptacao\microuniverso.pubkey"
    $excluirArquivoLimpo = $false

    mu.criptografarArquivoConfiguracaoUsandoChavePublica    -enderecoArquivoLimpo $enderecoArquivoLimpo `
                                                            -enderecoArquivoCriptografado $enderecoArquivoCriptografado `
                                                            -enderecoChavePublica $enderecoChavePublica `
                                                            -excluirArquivoLimpo $excluirArquivoLimpo
}

function global:mu.decriptografarArquivoConfiguracaoUsandoChavePrivada.test() {
    $enderecoArquivoCriptografado = "C:\microuniversoWeb\microuniversoWeb.yaml.modificado.encm"
    $enderecoArquivoDecriptografado = "C:\microuniversoWeb\microuniversoWeb.yaml.modificado.dencm"
    $enderecoChavePrivada = "C:\mu-scripts\scripts_implantacao\encriptacao\microuniverso.privkey"
    $senhaChavePrivada = "microuniverso"

    mu.decriptografarArquivoConfiguracaoUsandoChavePrivada  -enderecoArquivoCriptografado $enderecoArquivoCriptografado `
                                                            -enderecoArquivoDecriptografado $enderecoArquivoDecriptografado `
                                                            -senhaChavePrivada $senhaChavePrivada `
                                                            -enderecoChavePrivada $enderecoChavePrivada
}

