const { argv } = require('yargs')
const { decryptFileRSA_AES } = require('./encryptUtils')
const fs = require('fs')

async function main() {
    const privateKeyPath = argv["privateKeyPath"]
    const source = argv["source"]
    const destination = argv["destination"]
    const privateKeyPassword = argv["privateKeyPassword"].toString()

    await decryptFileRSA_AES({
        filePathEncrypted: source,
        filePathDecrypted: destination,
        privateKey: fs.readFileSync(privateKeyPath,{encoding: 'utf8'}),
        privateKeyPassword: privateKeyPassword
    })
}

main().then(() => process.exit(0)).catch(error => {
    console.error(error)
    process.exit(1)
})