. $PSScriptRoot\configuracoesMicrouniversoWeb.ps1
. $PSScriptRoot\pararProcessosEServicosNecessarios.ps1
. $PSScriptRoot\manterAlgunsValoresWebConfig.ps1

function global:_mu.copiarServico() {
    param(
        $nomeServico,
        $configuracoes,
        $diretorioReleaseWeb,
        $enderecoArquivoConfiguracao
    )

    _echo "Copiando $nomeServico"

    $servico = $configuracoes.servicos."$nomeServico"

    if (!($servico.configurar)) {
        _echo "Servico $nomeServico nao sera configurado. Desativado via configuracao" warn
        return
    }

    $diretorioInstalacao = if ("diretorioRelativoInstalacao" -in $servico.psobject.properties.name) {
        "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($servico.diretorioRelativoInstalacao)"
    } elseif ("diretorioAbsolutoInstalacao" -in $servico.psobject.properties.name) {
        $servico.diretorioAbsolutoInstalacao
    } else {
        throw "Diretorio de instalacao nao informado para $nomeServico"
    }

    if (!(test-path "$diretorioInstalacao")) {
        New-Item -Path "$diretorioInstalacao" -ItemType Directory
    }

    $diretorioNoReleaseWeb = if ("diretorioRelativoReleaseWeb" -in $servico.psobject.properties.name) {
        "$diretorioReleaseWeb\$($servico.diretorioRelativoReleaseWeb)"
    } else {
        $null
    }

    if ($null -eq $diretorioNoReleaseWeb) {
        _echo "Diretorio no release web nao informado para servico $nomeServico. Nada sera copiado"
        return
    }

    
    mu.executarScriptPython -script "$psscriptroot\scriptsPython\salvar_propiedades_web_config.py" -argumentos "$enderecoArquivoConfiguracao $nomeServico salvar"
    # mu.copiarAlgunsValoresDoWebConfig $nomeServico $configuracoes $diretorioReleaseWeb

    Copy-Item "$diretorioNoReleaseWeb\*" "$diretorioInstalacao" -Recurse -force
    
    mu.executarScriptPython -script "$psscriptroot\scriptsPython\salvar_propiedades_web_config.py" -argumentos "$enderecoArquivoConfiguracao $nomeServico restaurar"
    # mu.restaurarValoresDoWebConfig $nomeServico $configuracoes $diretorioReleaseWeb
}
function global:mu.copiarServicosParaDiretorioInstalacao() {
    param(
        $configuracoes,
        $diretorioReleaseWeb,
        $enderecoArquivoConfiguracao
    )

    if (-not (_mu.necessarioReiniciarIIS $configuracoes)) {
        _echo "Nenhum servico que usa o IIS sera configurado. Servicos nao serao copiados" warn
        return
    }
    
    $diretorioBaseInstalacao = $configuracoes.enderecos.diretorioBaseInstalacao

    if (!(Test-Path $diretorioReleaseWeb)) {
        throw "Diretorio do release web nao encontrado"
    }

    if (!(test-path $diretorioBaseInstalacao)) {
        New-Item -Path $diretorioBaseInstalacao -ItemType Directory
    }

    _mu.copiarServico "rest" $configuracoes $diretorioReleaseWeb $enderecoArquivoConfiguracao
    _mu.copiarServico "authServer" $configuracoes $diretorioReleaseWeb $enderecoArquivoConfiguracao
    _mu.copiarServico "resourceServer" $configuracoes $diretorioReleaseWeb  $enderecoArquivoConfiguracao 
    _mu.copiarServico "segurancaWeb" $configuracoes $diretorioReleaseWeb $enderecoArquivoConfiguracao
    _mu.copiarServico "imagensProdutos" $configuracoes $diretorioReleaseWeb $enderecoArquivoConfiguracao
    _mu.copiarServico "orcamentoWeb" $configuracoes $diretorioReleaseWeb $enderecoArquivoConfiguracao
    _mu.copiarServico "carrinhoDeCompra" $configuracoes $diretorioReleaseWeb $enderecoArquivoConfiguracao
    _mu.copiarServico "financeiro" $configuracoes $diretorioReleaseWeb $enderecoArquivoConfiguracao
    _mu.copiarServico "liberarPendencia" $configuracoes $diretorioReleaseWeb $enderecoArquivoConfiguracao
    _mu.copiarServico "ordemDeCompra" $configuracoes $diretorioReleaseWeb $enderecoArquivoConfiguracao
    _mu.copiarServico "wcf" $configuracoes $diretorioReleaseWeb $enderecoArquivoConfiguracao
    _mu.copiarServico "fenixWrapper" $configuracoes $diretorioReleaseWeb $enderecoArquivoConfiguracao
}
