. $PSScriptRoot\_echo.ps1
. $PSScriptRoot\configuracoesMicrouniversoWeb.ps1

function global:mu.microkafkaWindows.dados() {
    return @{
        arquivoZipKafka = "$PSScriptRoot\kafka_2.13-3.4.0.zip"
        arquivoZipNSSM = "$PSScriptRoot\nssm-2.24.zip"
        diretorioKafka = "c:\microuniversoWeb\kafka"
        diretorioDadosKafka = "c:\microuniversoWeb\kafka-data"
        diretorioNSSM = "c:\microuniversoWeb\nssm-2.24"
        diretorioPython = "c:\microuniversoWeb\python-3.10.8.v3"
        pythonExe = "c:\microuniversoWeb\python-3.10.8.v3\python.exe"
        repositorioLocalMicrokafka = "c:\temp\Microkafka"

    }
}

function global:mu.microkafkaWindows.extrairArquivoZipKafka () {
    $arquivoZip = (mu.microkafkaWindows.dados).arquivoZipKafka
    $diretorioKafka = (mu.microkafkaWindows.dados).diretorioKafka

    if (Test-Path $diretorioKafka) {
        remove-item -force -recurse $diretorioKafka
    }

    _echo "Extraindo $arquivoZip para $diretorioKafka"

    Expand-Archive $arquivoZip -DestinationPath $diretorioKafka
    

}

function global:mu.microkafkaWindows.extrairNSSM() {
    $arquivoZip = (mu.microkafkaWindows.dados).arquivoZipNSSM
    $diretorioNSSM = (mu.microkafkaWindows.dados).diretorioNSSM

    if (Test-Path $diretorioNSSM) {
        remove-item -force -recurse $diretorioNSSM
    }

    _echo "Extraindo $arquivoZip para $diretorioNSSM"

    Expand-Archive $arquivoZip -DestinationPath $diretorioNSSM
}

function global:mu.microkafkaWindows.ajustarConfiguracao() {
    param(
        $configuracoes
    )

    $diretorioKafka = (mu.microkafkaWindows.dados).diretorioKafka
    $diretorioDadosKafka = (mu.microkafkaWindows.dados).diretorioDadosKafka
    
    $arquivoZookeperProperties = "$((mu.microkafkaWindows.dados).diretorioKafka)\config\zookeeper.properties"
    $arquivoKafkaRunClassBat = "$((mu.microkafkaWindows.dados).diretorioKafka)\bin\windows\kafka-run-class.bat"

    if (-not (test-path $arquivoZookeperProperties)) {
        _echo "Arquivo zookeper.properties nao foi encontrado em $arquivoZookeperProperties"
        return
    }

    $diretorioZookeeperData = "$diretorioDadosKafka\zookeeper-data"

    if (-not (test-path $diretorioZookeeperData)) {
        mkdir diretorioZookeeperData
    }
    $diretorioZookeeperDataParaArquivoConfig = $diretorioZookeeperData -replace "\\","/"

    if (-not (test-path $diretorioZookeeperData)) {
        mkdir $diretorioZookeeperData
    }

    _echo "Ajustando configuracao do arquivo $arquivoZookeperProperties"

    ((get-content $arquivoZookeperProperties -raw) -replace "dataDir=.*","dataDir=$diretorioZookeeperDataParaArquivoConfig") | out-file $arquivoZookeperProperties -encoding "ASCII"

    $arquivoServerProperties = "$((mu.microkafkaWindows.dados).diretorioKafka)\config\server.properties"
    $kakfaLogsDir = "$diretorioDadosKafka\kafka-logs"

    if (-not (test-path $kakfaLogsDir)) {
        mkdir $kakfaLogsDir
    }

    $kakfaLogsDirParaArquivoConfig = $kakfaLogsDir -replace "\\","/"

    _echo "Ajustando configuracao do arquivo $arquivoServerProperties"

    (get-content $arquivoServerProperties) -replace "log\.dirs=.*$", "log.dirs=$kakfaLogsDirParaArquivoConfig" | out-file $arquivoServerProperties -encoding "ASCII"
    ((get-content $arquivoServerProperties -raw) -replace "#listeners=.*","listeners=PLAINTEXT://$($configuracoes.microkafka.windows.enderecoHost):9093") | out-file $arquivoServerProperties -encoding "ASCII"

    if (($configuracoes.microkafka.windows.enderecoJavaHome -eq "") -or ($configuracoes.microkafka.windows.enderecoJavaHome -eq $null)) {
        _echo "Endereco do JAVA_HOME nao foi informado. Nao sera configurado no arquivo $arquivoKafkaRunClassBat"
    } else {
        _echo "Ajustando endereco do JAVA_HOME no arquivo $arquivoKafkaRunClassBat para $($configuracoes.microkafka.windows.enderecoJavaHome)"
        (get-content $arquivoKafkaRunClassBat -raw) -replace "rem Which java to use", "set JAVA_HOME=$($configuracoes.microkafka.windows.enderecoJavaHome)" | out-file $arquivoKafkaRunClassBat -encoding "ASCII"
    }

    add-content $arquivoServerProperties -Value "message.max.bytes=31457280"

    

}

function global:mu.microkafkaWindows.executarComando() {
    param(
        $descricao,
        $comando
    )

    _echo "$descricao. comando: $comando"
    invoke-expression $comando
}

function global:mu.microkafkaWindows.pararServicoZookeeper() {

    # $nssm = "$($(mu.microkafkaWindows.dados).diretorioNSSM)\win64\nssm.exe"

    mu.microkafkaWindows.executarComando -descricao "Parando zookeeper" -comando "cmd /c sc stop zookeeper"

    $contador = 1

    while ((mu.microkafkaWindows.zookeeperEstaRodando)) {
        mu.microkafkaWindows.executarComando -descricao "Parando zookeeper" -comando "cmd /c sc stop zookeeper"
        
        _echo "Aguardando servico zookeeper parar... $contador" 

        Start-Sleep 2

        $contador = $contador + 1
    }
}

function global:mu.microkafkaWindows.pararServicoKafka() {

    mu.microkafkaWindows.executarComando -descricao "Parando servico kafka" -comando "cmd /c sc stop kafka"

    $contador = 1

    while (mu.microkafkaWindows.kafkaEstaRodando) {
        mu.microkafkaWindows.executarComando -descricao "Parando servico kafka" -comando "cmd /c sc stop kafka"

        _echo "Aguardando servico kafka parar... $contador"

        Start-Sleep 2

        $contador = $contador + 1
    }
}

function global:mu.microkafkaWindows.configurarEIniciarServicoZookeeper() {
    $nssm = "$($(mu.microkafkaWindows.dados).diretorioNSSM)\win64\nssm.exe"
    $startZookeeperBat = "$($(mu.microkafkaWindows.dados).diretorioKafka)\bin\windows\zookeeper-server-start.bat"
    $zookeeperProperties = "$($(mu.microkafkaWindows.dados).diretorioKafka)\config\zookeeper.properties"

    (mu.microkafkaWindows.pararServicoZookeeper)

    $ErrorActionPreference_back = $ErrorActionPreference

    $ErrorActionPreference = 'Continue'

    mu.microkafkaWindows.executarComando -descricao "Removendo servico zookeeper" -comando "$nssm remove zookeeper confirm"

    $ErrorActionPreference = $ErrorActionPreference_back

    mu.microkafkaWindows.executarComando -descricao "Instalando servico zookeeper" -comando "$nssm install zookeeper ""$startZookeeperBat"" ""$zookeeperProperties"""

    mu.microkafkaWindows.executarComando -descricao "Iniciando servico do zookeeper" -comando "$nssm start zookeeper"


}

function global:mu.microkafkaWindows.configurarEIniciarServicokafka() {
    $nssm = "$($(mu.microkafkaWindows.dados).diretorioNSSM)\win64\nssm.exe"
    $startKafkaBat = "$($(mu.microkafkaWindows.dados).diretorioKafka)\bin\windows\kafka-server-start.bat"
    $serverProperties = "$($(mu.microkafkaWindows.dados).diretorioKafka)\config\server.properties"

    (mu.microkafkaWindows.pararServicoKafka)

    $ErrorActionPreference_back = $ErrorActionPreference

    $ErrorActionPreference = 'Continue'

    mu.microkafkaWindows.executarComando -descricao "Removendo servico kafka" -comando "$nssm remove kafka confirm"
    
    $ErrorActionPreference = $ErrorActionPreference_back

    mu.microkafkaWindows.executarComando -descricao "Instalando servico kafka" -comando "$nssm install kafka ""$startKafkaBat"" ""$serverProperties"" "

    mu.microkafkaWindows.executarComando -descricao "Iniciando servico kafka" -comando "$nssm start kafka"


}

function global:mu.microkafkaWindows.zookeeperEstaRodando() {
    [array] $verificacao = (netstat -an | findstr ":2181" | findstr "LISTENING")

    return $verificacao -ne $null -and $verificacao.Count -gt 0
}

function global:mu.microkafkaWindows.kafkaEstaRodando() {
    [array] $verificacao = (netstat -an | findstr ":9093" | findstr "LISTENING")

    return $verificacao -ne $null -and $verificacao.Count -gt 0
}



function global:mu.microkafkaWindows.baixarScriptsConfiguracao() {
    param(
        $configuracoes
    )

    $usuarioEncoded = [System.Web.HttpUtility]::UrlEncode($configuracoes.acessos.git.usuario)
    $senhaEncoded = [System.Web.HttpUtility]::UrlEncode($configuracoes.acessos.git.senha)

    $urlRepositorio = "https://${usuarioEncoded}:${senhaEncoded}@gitlab.com/MUFenix/MicroKafka.git"

    $diretorioRepositorioLocal = $(mu.microkafkaWindows.dados).repositorioLocalMicrokafka

    if (test-path $diretorioRepositorioLocal) {
        remove-item -recurse -force $diretorioRepositorioLocal
    }

    _echo "Clonando repositorio Microkafka em $diretorioRepositorioLocal"

    $ErrorActionPreference_back = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'

    git clone -b master --depth 1 $urlRepositorio $diretorioRepositorioLocal

    _echo "Repositorio Microkafka clonado em $diretorioRepositorioLocal"

    $ErrorActionPreference = $ErrorActionPreference_back
}

function global:mu.microkafkaWindows.executarScriptDeConfiguracao() {
    param(
        $configuracoes
    )

    $pythonExe = $(mu.microkafkaWindows.dados).pythonExe
    $scriptsConfiguracaoMain = "$($(mu.microkafkaWindows.dados).repositorioLocalMicrokafka)\scripts-configuracao\main.py"
    $argumentos = "--ambiente=WINDOWS --microkafkaHost=$($configuracoes.microkafka.windows.enderecoHost)"

    _echo "Aguardando kafka estar acessivel"

    $contador = 1

    while (-not (mu.microkafkaWindows.kafkaEstaRodando)) {
        _echo "Aguardando kafka estar acessivel... $contador"

        $contador = $contador + 1

        Start-Sleep 2

    }

    $ErrorActionPreference_back = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'

    mu.microkafkaWindows.executarComando -descricao "Configurando microkafka" -comando "$pythonExe $scriptsConfiguracaoMain $argumentos"

    $ErrorActionPreference = $ErrorActionPreference_back
    
}

function global:mu.microkafkaWindows.configurar() {
    param(
        $configuracoes
    )

    (mu.microkafkaWindows.pararServicoKafka)

    (mu.microkafkaWindows.pararServicoZookeeper)

    (mu.microkafkaWindows.extrairNSSM)

    (mu.microkafkaWindows.extrairArquivoZipKafka)

    mu.microkafkaWindows.ajustarConfiguracao -configuracoes $configuracoes

    (mu.microkafkaWindows.configurarEIniciarServicoZookeeper)

    (mu.microkafkaWindows.configurarEIniciarServicokafka)

    mu.microkafkaWindows.baixarScriptsConfiguracao -configuracoes $configuracoes

    mu.microkafkaWindows.executarScriptDeConfiguracao -configuracoes $configuracoes
}

## FUNCOES DE TESTE ##
function global:mu.microkafkaWindows.configurarEIniciarServicoZookeeper.test() {
    $ErrorActionPreference = 'Stop'
    (mu.microkafkaWindows.configurarEIniciarServicoZookeeper)
}

function global:mu.microkafkaWindows.configurarEIniciarServicokafka.test() {
    #$ErrorActionPreference = 'Stop'
    (mu.microkafkaWindows.configurarEIniciarServicokafka)
}

function global:mu.microkafkaWindows.ajustarConfiguracao.test() {
    $enderecoArquivoConfiguracao = "C:\TrabalhoWeb\ScriptsDeploy\scripts_implantacao\arquivos-yml-teste\microuniversoWeb-microkafka-windows.yaml"

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $enderecoArquivoConfiguracao

    mu.microkafkaWindows.ajustarConfiguracao -configuracoes $configuracoes
}


function global:mu.microkafkaWindows.extrairNSSM.test() {
    (mu.microkafkaWindows.extrairNSSM)   
}

function global:mu.microkafkaWindows.extrairArquivoZipKafka.test () {
    
    (mu.microkafkaWindows.extrairArquivoZipKafka)
}

function global:mu.microkafkaWindows.baixarScriptsConfiguracao.test() {
    $enderecoArquivoConfiguracao = "C:\TrabalhoWeb\ScriptsDeploy\scripts_implantacao\arquivos-yml-teste\microuniversoWeb-microkafka-windows.yaml"

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $enderecoArquivoConfiguracao

    mu.microkafkaWindows.baixarScriptsConfiguracao -configuracoes $configuracoes
}

function global:mu.microkafkaWindows.executarScriptDeConfiguracao.test() {
    $enderecoArquivoConfiguracao = "C:\TrabalhoWeb\ScriptsDeploy\scripts_implantacao\arquivos-yml-teste\microuniversoWeb-microkafka-windows.yaml"
    
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $enderecoArquivoConfiguracao

    mu.microkafkaWindows.configurarMicrokafka -configuracoes $configuracoes
}

function global:mu.microkafkaWindows.configurar.test() {
    $enderecoArquivoConfiguracao = "C:\TrabalhoWeb\ScriptsDeploy\scripts_implantacao\arquivos-yml-teste\microuniversoWeb-microkafka-windows.yaml"

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $enderecoArquivoConfiguracao

    mu.microkafkaWindows.configurar -configuracoes $configuracoes
}