/*
 * Decompiled with CFR 0.152.
 */
package io.github.stephenc.crypto.sscg.internal.bc.operator.bc;

import io.github.stephenc.crypto.sscg.internal.bc.asn1.x509.AlgorithmIdentifier;
import io.github.stephenc.crypto.sscg.internal.bc.crypto.CryptoException;
import io.github.stephenc.crypto.sscg.internal.bc.crypto.Signer;
import io.github.stephenc.crypto.sscg.internal.bc.crypto.params.AsymmetricKeyParameter;
import io.github.stephenc.crypto.sscg.internal.bc.crypto.params.ParametersWithRandom;
import io.github.stephenc.crypto.sscg.internal.bc.operator.ContentSigner;
import io.github.stephenc.crypto.sscg.internal.bc.operator.OperatorCreationException;
import io.github.stephenc.crypto.sscg.internal.bc.operator.RuntimeOperatorException;
import io.github.stephenc.crypto.sscg.internal.bc.operator.bc.BcDefaultDigestProvider;
import io.github.stephenc.crypto.sscg.internal.bc.operator.bc.BcDigestProvider;
import io.github.stephenc.crypto.sscg.internal.bc.operator.bc.BcSignerOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

public abstract class BcContentSignerBuilder {
    private SecureRandom random;
    private AlgorithmIdentifier sigAlgId;
    private AlgorithmIdentifier digAlgId;
    protected BcDigestProvider digestProvider;

    public BcContentSignerBuilder(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2) {
        this.sigAlgId = algorithmIdentifier;
        this.digAlgId = algorithmIdentifier2;
        this.digestProvider = BcDefaultDigestProvider.INSTANCE;
    }

    public BcContentSignerBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public ContentSigner build(AsymmetricKeyParameter asymmetricKeyParameter) throws OperatorCreationException {
        final Signer signer = this.createSigner(this.sigAlgId, this.digAlgId);
        if (this.random != null) {
            signer.init(true, new ParametersWithRandom(asymmetricKeyParameter, this.random));
        } else {
            signer.init(true, asymmetricKeyParameter);
        }
        return new ContentSigner(){
            private BcSignerOutputStream stream;
            {
                this.stream = new BcSignerOutputStream(signer);
            }

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return BcContentSignerBuilder.this.sigAlgId;
            }

            public OutputStream getOutputStream() {
                return this.stream;
            }

            public byte[] getSignature() {
                try {
                    return this.stream.getSignature();
                }
                catch (CryptoException cryptoException) {
                    throw new RuntimeOperatorException("exception obtaining signature: " + cryptoException.getMessage(), cryptoException);
                }
            }
        };
    }

    protected abstract Signer createSigner(AlgorithmIdentifier var1, AlgorithmIdentifier var2) throws OperatorCreationException;
}

