/*
 * Decompiled with CFR 0.152.
 */
package io.github.stephenc.crypto.sscg;

import io.github.stephenc.crypto.sscg.internal.bc.asn1.ASN1ObjectIdentifier;
import io.github.stephenc.crypto.sscg.internal.bc.asn1.x500.X500Name;
import io.github.stephenc.crypto.sscg.internal.bc.asn1.x500.X500NameBuilder;
import io.github.stephenc.crypto.sscg.internal.bc.asn1.x500.style.BCStyle;
import io.github.stephenc.crypto.sscg.internal.bc.asn1.x509.AlgorithmIdentifier;
import io.github.stephenc.crypto.sscg.internal.bc.asn1.x509.SubjectPublicKeyInfo;
import io.github.stephenc.crypto.sscg.internal.bc.asn1.x509.X509Extension;
import io.github.stephenc.crypto.sscg.internal.bc.cert.X509v3CertificateBuilder;
import io.github.stephenc.crypto.sscg.internal.bc.cert.jcajce.JcaX509ExtensionUtils;
import io.github.stephenc.crypto.sscg.internal.bc.crypto.params.RSAKeyParameters;
import io.github.stephenc.crypto.sscg.internal.bc.jcajce.provider.asymmetric.dsa.DSAUtil;
import io.github.stephenc.crypto.sscg.internal.bc.jcajce.provider.asymmetric.util.ECUtil;
import io.github.stephenc.crypto.sscg.internal.bc.jce.provider.BouncyCastleProvider;
import io.github.stephenc.crypto.sscg.internal.bc.operator.ContentSigner;
import io.github.stephenc.crypto.sscg.internal.bc.operator.DefaultDigestAlgorithmIdentifierFinder;
import io.github.stephenc.crypto.sscg.internal.bc.operator.DefaultSignatureAlgorithmIdentifierFinder;
import io.github.stephenc.crypto.sscg.internal.bc.operator.OperatorCreationException;
import io.github.stephenc.crypto.sscg.internal.bc.operator.bc.BcDSAContentSignerBuilder;
import io.github.stephenc.crypto.sscg.internal.bc.operator.bc.BcECContentSignerBuilder;
import io.github.stephenc.crypto.sscg.internal.bc.operator.bc.BcRSAContentSignerBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class SelfSignedCertificate {
    private static final BouncyCastleProvider BOUNCY_CASTLE_PROVIDER = new BouncyCastleProvider();
    private final KeyPair keyPair;
    private Date firstDate = new Date();
    private Date lastDate = new Date(this.firstDate.getTime() + TimeUnit.DAYS.toMillis(365L));
    private X500NameBuilder subject = new X500NameBuilder(BCStyle.INSTANCE);
    private String hashAlg = "SHA1";

    private SelfSignedCertificate(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public static SelfSignedCertificate forKeyPair(KeyPair keyPair) {
        return new SelfSignedCertificate(keyPair);
    }

    public SelfSignedCertificate validFrom(Date date) {
        this.firstDate = date == null ? new Date() : (Date)date.clone();
        return this;
    }

    public SelfSignedCertificate validUntil(Date date) {
        this.lastDate = date == null ? new Date(this.firstDate.getTime() + TimeUnit.DAYS.toMillis(365L)) : (Date)date.clone();
        return this;
    }

    public SelfSignedCertificate cn(String name) {
        this.subject.addRDN(BCStyle.CN, name);
        return this;
    }

    public SelfSignedCertificate c(String name) {
        this.subject.addRDN(BCStyle.C, name);
        return this;
    }

    public SelfSignedCertificate o(String name) {
        this.subject.addRDN(BCStyle.O, name);
        return this;
    }

    public SelfSignedCertificate ou(String name) {
        this.subject.addRDN(BCStyle.OU, name);
        return this;
    }

    public SelfSignedCertificate oid(String oid, String name) {
        this.subject.addRDN(new ASN1ObjectIdentifier(oid), name);
        return this;
    }

    public SelfSignedCertificate sha1() {
        this.hashAlg = "SHA1";
        return this;
    }

    public SelfSignedCertificate sha224() {
        this.hashAlg = "SHA224";
        return this;
    }

    public SelfSignedCertificate sha256() {
        this.hashAlg = "SHA256";
        return this;
    }

    public SelfSignedCertificate sha384() {
        this.hashAlg = "SHA384";
        return this;
    }

    public SelfSignedCertificate sha512() {
        this.hashAlg = "SHA512";
        return this;
    }

    public X509Certificate generate() throws IOException {
        try {
            ContentSigner signer;
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(this.keyPair.getPublic().getEncoded());
            X500Name subject = this.subject.build();
            X509v3CertificateBuilder certGen = new X509v3CertificateBuilder(subject, BigInteger.ONE, this.firstDate, this.lastDate, subject, subjectPublicKeyInfo);
            JcaX509ExtensionUtils instance = new JcaX509ExtensionUtils();
            certGen.addExtension(X509Extension.subjectKeyIdentifier, false, instance.createSubjectKeyIdentifier(subjectPublicKeyInfo));
            if (this.keyPair.getPrivate() instanceof RSAPrivateKey) {
                RSAPrivateKey privateKey = (RSAPrivateKey)this.keyPair.getPrivate();
                AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(this.hashAlg + "withRSA");
                AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
                signer = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(new RSAKeyParameters(true, privateKey.getModulus(), privateKey.getPrivateExponent()));
            } else if (this.keyPair.getPrivate() instanceof DSAPrivateKey) {
                DSAPrivateKey privateKey = (DSAPrivateKey)this.keyPair.getPrivate();
                AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(this.hashAlg + "withDSA");
                AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
                signer = new BcDSAContentSignerBuilder(sigAlgId, digAlgId).build(DSAUtil.generatePrivateKeyParameter(privateKey));
            } else if (this.keyPair.getPrivate() instanceof ECPrivateKey) {
                ECPrivateKey privateKey = (ECPrivateKey)this.keyPair.getPrivate();
                AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(this.hashAlg + "withECDSA");
                AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
                signer = new BcECContentSignerBuilder(sigAlgId, digAlgId).build(ECUtil.generatePrivateKeyParameter(privateKey));
            } else {
                throw new IOException("Unsupported key type");
            }
            return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certGen.build(signer).getEncoded()));
        }
        catch (OperatorCreationException e) {
            throw new IOException("Failed to generate a certificate", e);
        }
        catch (CertificateException e) {
            throw new IOException("Failed to generate a certificate", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Failed to generate a certificate", e);
        }
        catch (InvalidKeyException e) {
            throw new IOException("Failed to generate a certificate", e);
        }
    }
}

