/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.pipeline;

import com.google.common.util.concurrent.FutureCallback;
import hudson.Extension;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.plugins.timestamper.Messages;
import hudson.plugins.timestamper.TimestampNotesOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.annotation.Nonnull;
import jenkins.YesNoMaybe;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class TimestamperStep
extends AbstractStepImpl {
    @DataBoundConstructor
    public TimestamperStep() {
    }

    private static class TimestampNotesConsoleLogFilter
    extends ConsoleLogFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long startTime;

        TimestampNotesConsoleLogFilter(Run<?, ?> build) {
            this.startTime = build.getStartTimeInMillis();
        }

        public OutputStream decorateLogger(AbstractBuild _ignore, OutputStream logger) throws IOException, InterruptedException {
            return new TimestampNotesOutputStream(logger, this.startTime);
        }
    }

    @Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(ExecutionImpl.class);
        }

        public String getDisplayName() {
            return Messages.Timestamps();
        }

        public String getFunctionName() {
            return "timestamps";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public String getHelpFile() {
            return this.getDescriptorFullUrl() + "/help";
        }

        public void doHelp(StaplerRequest request, StaplerResponse response) throws IOException {
            response.setContentType("text/html;charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.println(Messages.Description());
            writer.flush();
        }
    }

    public static class ExecutionImpl
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;

        public boolean start() throws Exception {
            StepContext context = this.getContext();
            context.newBodyInvoker().withContext((Object)this.createConsoleLogFilter(context)).withCallback(BodyExecutionCallback.wrap((FutureCallback)context)).start();
            return false;
        }

        private ConsoleLogFilter createConsoleLogFilter(StepContext context) throws IOException, InterruptedException {
            ConsoleLogFilter original = (ConsoleLogFilter)context.get(ConsoleLogFilter.class);
            Run build = (Run)context.get(Run.class);
            TimestampNotesConsoleLogFilter subsequent = new TimestampNotesConsoleLogFilter(build);
            return BodyInvoker.mergeConsoleLogFilters((ConsoleLogFilter)original, (ConsoleLogFilter)subsequent);
        }

        public void stop(@Nonnull Throwable cause) throws Exception {
            this.getContext().onFailure(cause);
        }
    }
}

