/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.io;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import hudson.model.Run;
import hudson.plugins.timestamper.io.TimestamperPaths;
import hudson.plugins.timestamper.io.Varint;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.annotation.CheckForNull;

public class TimestampsWriter
implements Closeable {
    private static final int BUFFER_SIZE = 1024;
    private final File timestampsFile;
    private final Optional<MessageDigest> timestampsDigest;
    @CheckForNull
    private OutputStream timestampsOutput;
    private final byte[] buffer = new byte[1024];
    private long previousCurrentTimeMillis;

    public TimestampsWriter(Run<?, ?> build) throws IOException {
        this(build, (Optional<MessageDigest>)Optional.absent());
    }

    public TimestampsWriter(Run<?, ?> build, Optional<MessageDigest> digest) throws IOException {
        this(TimestamperPaths.timestampsFile(build), build.getStartTimeInMillis(), digest);
    }

    public TimestampsWriter(File timestampsFile, long buildStartTime, Optional<MessageDigest> digest) throws IOException {
        this.timestampsFile = timestampsFile;
        this.previousCurrentTimeMillis = buildStartTime;
        this.timestampsDigest = (Optional)Preconditions.checkNotNull(digest);
        Files.createParentDirs((File)timestampsFile);
        boolean fileCreated = timestampsFile.createNewFile();
        if (!fileCreated) {
            throw new IOException("File already exists: " + timestampsFile);
        }
    }

    public void write(long currentTimeMillis, int times) throws IOException {
        if (times < 1) {
            return;
        }
        long elapsedMillis = currentTimeMillis - this.previousCurrentTimeMillis;
        this.previousCurrentTimeMillis = currentTimeMillis;
        if (this.timestampsOutput == null) {
            this.timestampsOutput = this.openTimestampsStream();
        }
        this.writeVarintsTo(this.timestampsOutput, elapsedMillis);
        if (times > 1) {
            this.writeZerosTo(this.timestampsOutput, times - 1);
        }
    }

    private OutputStream openTimestampsStream() throws FileNotFoundException {
        OutputStream outputStream = new FileOutputStream(this.timestampsFile);
        if (this.timestampsDigest.isPresent()) {
            outputStream = new DigestOutputStream(outputStream, (MessageDigest)this.timestampsDigest.get());
        }
        return outputStream;
    }

    private void writeVarintsTo(OutputStream outputStream, long ... values) throws IOException {
        int offset = 0;
        for (long value : values) {
            offset = Varint.write(value, this.buffer, offset);
        }
        outputStream.write(this.buffer, 0, offset);
        outputStream.flush();
    }

    private void writeZerosTo(OutputStream outputStream, int n) throws IOException {
        Arrays.fill(this.buffer, (byte)0);
        while (n > 0) {
            int bytesToWrite = Math.min(n, this.buffer.length);
            n -= bytesToWrite;
            outputStream.write(this.buffer, 0, bytesToWrite);
            outputStream.flush();
        }
    }

    public void writeDigest() throws IOException {
        if (this.timestampsDigest.isPresent()) {
            this.writeDigest((MessageDigest)this.timestampsDigest.get());
        }
    }

    private void writeDigest(MessageDigest timestampsDigest) throws IOException {
        StringBuilder hash = new StringBuilder();
        for (byte b : timestampsDigest.digest()) {
            hash.append(String.format("%02x", b));
        }
        hash.append("\n");
        File digestFile = new File(this.timestampsFile.getParent(), this.timestampsFile.getName() + "." + timestampsDigest.getAlgorithm());
        Files.write((CharSequence)hash.toString(), (File)digestFile, (Charset)Charsets.US_ASCII);
    }

    @Override
    public void close() throws IOException {
        if (this.timestampsOutput != null) {
            this.timestampsOutput.close();
        }
    }
}

