/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.io;

import com.google.common.base.Optional;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingInputStream;
import hudson.model.Run;
import hudson.plugins.timestamper.Timestamp;
import hudson.plugins.timestamper.io.TimeShiftsReader;
import hudson.plugins.timestamper.io.TimestamperPaths;
import hudson.plugins.timestamper.io.Varint;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import org.apache.commons.io.IOUtils;

public class TimestampsReader
implements Serializable,
Closeable {
    private static final long serialVersionUID = 1L;
    private final File timestampsFile;
    private long filePointer;
    private long elapsedMillis;
    private long millisSinceEpoch;
    private long entry;
    private final TimeShiftsReader timeShiftsReader;
    @CheckForNull
    private transient InputStream inputStream;

    public TimestampsReader(Run<?, ?> build) {
        this.timestampsFile = TimestamperPaths.timestampsFile(build);
        this.timeShiftsReader = new TimeShiftsReader(build);
        this.millisSinceEpoch = build.getStartTimeInMillis();
    }

    public void skip(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            Optional<Timestamp> timestamp = this.read();
            if (timestamp.isPresent()) continue;
            return;
        }
    }

    public int getAbs(int lineNumber) throws IOException {
        this.skip(-lineNumber);
        int numberOfTimestampsFromStart = 0;
        Optional<Timestamp> timestamp;
        while ((timestamp = this.read()).isPresent()) {
            ++numberOfTimestampsFromStart;
        }
        return numberOfTimestampsFromStart;
    }

    public Optional<Timestamp> read() throws IOException {
        if (this.inputStream == null) {
            if (!this.timestampsFile.isFile()) {
                return Optional.absent();
            }
            this.inputStream = new FileInputStream(this.timestampsFile);
            ByteStreams.skipFully((InputStream)this.inputStream, (long)this.filePointer);
            this.inputStream = new BufferedInputStream(this.inputStream);
        }
        Optional timestamp = Optional.absent();
        if (this.filePointer < this.timestampsFile.length()) {
            timestamp = Optional.of((Object)this.readNext(this.inputStream));
        }
        return timestamp;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((InputStream)this.inputStream);
        this.inputStream = null;
    }

    private Timestamp readNext(InputStream inputStream) throws IOException {
        CountingInputStream countingInputStream = new CountingInputStream(inputStream);
        long elapsedMillisDiff = Varint.read((InputStream)countingInputStream);
        this.elapsedMillis += elapsedMillisDiff;
        this.millisSinceEpoch = (Long)this.timeShiftsReader.getTime(this.entry).or((Object)(this.millisSinceEpoch + elapsedMillisDiff));
        this.filePointer += countingInputStream.getCount();
        ++this.entry;
        return new Timestamp(this.elapsedMillis, this.millisSinceEpoch);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        IOUtils.closeQuietly((InputStream)this.inputStream);
    }
}

