/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.io;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CountingInputStream;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import hudson.plugins.timestamper.io.TimestamperPaths;
import hudson.plugins.timestamper.io.Varint;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;

class TimeShiftsReader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final File timeShiftsFile;
    @CheckForNull
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient Map<Long, Long> timeShifts;

    TimeShiftsReader(Run<?, ?> build) {
        this.timeShiftsFile = TimestamperPaths.timeShiftsFile(build);
    }

    Optional<Long> getTime(long timestampEntry) throws IOException {
        if (this.timeShifts == null) {
            this.timeShifts = ImmutableMap.copyOf(this.readTimeShifts());
        }
        return Optional.fromNullable((Object)this.timeShifts.get(timestampEntry));
    }

    private Map<Long, Long> readTimeShifts() throws IOException {
        if (!this.timeShiftsFile.isFile()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Long> timeShifts = new HashMap<Long, Long>();
        try (CountingInputStream inputStream = new CountingInputStream((InputStream)new BufferedInputStream(new FileInputStream(this.timeShiftsFile)));){
            while (inputStream.getCount() < this.timeShiftsFile.length()) {
                long entry = Varint.read((InputStream)inputStream);
                long shift = Varint.read((InputStream)inputStream);
                timeShifts.put(entry, shift);
            }
        }
        return timeShifts;
    }
}

