/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.io;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.CountingInputStream;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.console.ConsoleNote;
import hudson.model.Run;
import hudson.plugins.timestamper.Timestamp;
import hudson.plugins.timestamper.TimestampNote;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class LogFileReader
implements Closeable {
    private final Run<?, ?> build;
    @CheckForNull
    private BufferedReader reader;

    public LogFileReader(Run<?, ?> build) {
        this.build = (Run)Preconditions.checkNotNull(build);
    }

    public Optional<Line> nextLine() throws IOException {
        String line;
        if (!this.build.getLogFile().exists()) {
            return Optional.absent();
        }
        if (this.reader == null) {
            this.reader = new BufferedReader(this.build.getLogReader());
        }
        if ((line = this.reader.readLine()) == null) {
            return Optional.absent();
        }
        return Optional.of((Object)new Line(line, this.build));
    }

    @SuppressFBWarnings(value={"RV_DONT_JUST_NULL_CHECK_READLINE"})
    public int lineCount() throws IOException {
        if (!this.build.getLogFile().exists()) {
            return 0;
        }
        int lineCount = 0;
        try (BufferedReader reader = new BufferedReader(this.build.getLogReader());){
            while (reader.readLine() != null) {
                ++lineCount;
            }
        }
        return lineCount;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Reader)this.reader);
    }

    public static class Line {
        private final String line;
        private final Run<?, ?> build;

        private Line(String line, Run<?, ?> build) {
            this.line = (String)Preconditions.checkNotNull((Object)line);
            this.build = (Run)Preconditions.checkNotNull(build);
        }

        public String getText() {
            return ConsoleNote.removeNotes((String)this.line);
        }

        public Optional<Timestamp> readTimestamp() {
            byte[] bytes = this.line.getBytes(this.build.getCharset());
            int length = bytes.length;
            int index = 0;
            while ((index = ConsoleNote.findPreamble((byte[])bytes, (int)index, (int)(length - index))) != -1) {
                CountingInputStream inputStream = new CountingInputStream((InputStream)new ByteArrayInputStream(bytes, index, length - index));
                try {
                    ConsoleNote consoleNote = ConsoleNote.readFrom((DataInputStream)new DataInputStream((InputStream)inputStream));
                    if (consoleNote instanceof TimestampNote) {
                        TimestampNote timestampNote = (TimestampNote)consoleNote;
                        Timestamp timestamp = timestampNote.getTimestamp(this.build);
                        return Optional.of((Object)timestamp);
                    }
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                index = (int)((long)index + Math.max(inputStream.getCount(), 1L));
            }
            return Optional.absent();
        }

        public int hashCode() {
            return Objects.hash(this.line, this.build);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Line) {
                Line other = (Line)obj;
                return this.line.equals(other.line) && this.build.equals(other.build);
            }
            return false;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("line", (Object)this.line).append("build", this.build).toString();
        }
    }
}

