/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.io;

import com.google.common.base.Joiner;
import com.google.common.io.CountingInputStream;
import com.google.common.io.Files;
import hudson.plugins.timestamper.io.Varint;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public final class DumpTimestamps {
    public static void main(String ... args) throws IOException {
        if (args.length == 0) {
            throw new IllegalArgumentException("no command-line arguments");
        }
        File timestamperDir = new File(Joiner.on((char)' ').join((Object[])args));
        DumpTimestamps.dump(timestamperDir, "timestamps", 1);
        System.out.println();
        DumpTimestamps.dump(timestamperDir, "timeshifts", 2);
    }

    private static void dump(File parent, String filename, int columns) throws IOException {
        System.out.println(filename);
        File file = new File(parent, filename);
        if (!file.isFile()) {
            System.out.println("(none)");
            return;
        }
        byte[] fileContents = Files.toByteArray((File)file);
        CountingInputStream inputStream = new CountingInputStream((InputStream)new ByteArrayInputStream(fileContents));
        ArrayList<Long> values = new ArrayList<Long>();
        while (inputStream.getCount() < (long)fileContents.length) {
            values.add(Varint.read((InputStream)inputStream));
            if (values.size() != columns) continue;
            System.out.println(Joiner.on((char)'\t').join(values));
            values.clear();
        }
        if (!values.isEmpty()) {
            System.out.println(Joiner.on((char)'\t').join(values));
        }
    }

    private DumpTimestamps() {
    }
}

