/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.format;

import com.google.common.base.Optional;
import hudson.plugins.timestamper.Timestamp;
import hudson.plugins.timestamper.format.FormatStringUtils;
import hudson.plugins.timestamper.format.TimestampFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.time.FastDateFormat;

public final class SystemTimestampFormat
extends TimestampFormat {
    private static final String TIME_ZONE_PROPERTY = "org.apache.commons.jelly.tags.fmt.timeZone";
    private final FastDateFormat format;
    private final Optional<String> timeZoneId;

    public SystemTimestampFormat(String systemTimeFormat, Optional<String> timeZoneId, Locale locale) {
        TimeZone timeZone = null;
        if (timeZoneId.isPresent()) {
            timeZone = TimeZone.getTimeZone((String)timeZoneId.get());
        } else {
            String timeZoneProperty = System.getProperty(TIME_ZONE_PROPERTY);
            if (timeZoneProperty != null) {
                timeZone = TimeZone.getTimeZone(timeZoneProperty);
            }
        }
        this.format = FastDateFormat.getInstance((String)systemTimeFormat, (TimeZone)timeZone, (Locale)locale);
        this.timeZoneId = timeZoneId;
    }

    @Override
    public String apply(@Nonnull Timestamp timestamp) {
        return this.format.format(new Date(timestamp.millisSinceEpoch));
    }

    @Override
    public String getPlainTextUrl() {
        String timeParamValue = this.format.getPattern();
        timeParamValue = FormatStringUtils.stripHtmlTags(timeParamValue);
        timeParamValue = FormatStringUtils.trim(timeParamValue);
        return "timestamps?time=" + timeParamValue + (this.timeZoneId.isPresent() ? "&timeZone=" + (String)this.timeZoneId.get() : "") + "&appendLog" + "&locale=" + this.format.getLocale();
    }

    public int hashCode() {
        return Objects.hash(this.format, this.timeZoneId);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SystemTimestampFormat) {
            SystemTimestampFormat other = (SystemTimestampFormat)obj;
            return this.format.equals((Object)other.format) && this.timeZoneId.equals(other.timeZoneId);
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("format", (Object)this.format.getPattern()).append("timeZoneId", this.timeZoneId).append("locale", (Object)this.format.getLocale()).toString();
    }
}

