/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.format;

import com.google.common.base.Preconditions;
import hudson.plugins.timestamper.Timestamp;
import hudson.plugins.timestamper.format.FormatStringUtils;
import hudson.plugins.timestamper.format.TimestampFormat;
import javax.annotation.Nonnull;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.time.DurationFormatUtils;

public final class ElapsedTimestampFormat
extends TimestampFormat {
    private final String elapsedTimeFormat;

    public ElapsedTimestampFormat(String elapsedTimeFormat) {
        this.elapsedTimeFormat = (String)Preconditions.checkNotNull((Object)elapsedTimeFormat);
    }

    @Override
    public String apply(@Nonnull Timestamp timestamp) {
        if (timestamp.elapsedMillisKnown) {
            return DurationFormatUtils.formatDuration((long)timestamp.elapsedMillis, (String)this.elapsedTimeFormat);
        }
        return "";
    }

    @Override
    public String getPlainTextUrl() {
        String elapsedParamValue = this.elapsedTimeFormat;
        elapsedParamValue = FormatStringUtils.stripHtmlTags(elapsedParamValue);
        elapsedParamValue = FormatStringUtils.trim(elapsedParamValue);
        return "timestamps?elapsed=" + elapsedParamValue + "&appendLog";
    }

    public int hashCode() {
        return this.elapsedTimeFormat.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ElapsedTimestampFormat) {
            ElapsedTimestampFormat other = (ElapsedTimestampFormat)obj;
            return this.elapsedTimeFormat.equals(other.elapsedTimeFormat);
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("format", (Object)this.elapsedTimeFormat).toString();
    }
}

