/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.annotator;

import hudson.Extension;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleAnnotatorFactory;
import hudson.plugins.timestamper.annotator.ConsoleLogParser;
import hudson.plugins.timestamper.annotator.TimestampAnnotator;
import hudson.plugins.timestamper.format.TimestampFormat;
import hudson.plugins.timestamper.format.TimestampFormatProvider;
import jenkins.YesNoMaybe;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

@Extension(dynamicLoadable=YesNoMaybe.YES)
public final class TimestampAnnotatorFactory2
extends ConsoleAnnotatorFactory<Object> {
    public ConsoleAnnotator<Object> newInstance(Object context) {
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request == null) {
            return null;
        }
        long offset = TimestampAnnotatorFactory2.getOffset(request);
        ConsoleLogParser logParser = new ConsoleLogParser(offset);
        return new TimestampAnnotator(logParser);
    }

    private static long getOffset(StaplerRequest request) {
        String path = request.getPathInfo();
        if (path == null) {
            path = request.getServletPath();
        }
        if (path.endsWith("/consoleFull")) {
            return 0L;
        }
        if (path.endsWith("/console")) {
            String threshold = System.getProperty("hudson.consoleTailKB", "150");
            return -(Long.parseLong(threshold) * 1024L);
        }
        String startParameter = request.getParameter("start");
        return startParameter == null ? 0L : Long.parseLong(startParameter);
    }

    public String getPlainTextUrl() {
        TimestampFormat format = TimestampFormatProvider.get();
        return format.getPlainTextUrl();
    }
}

