/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.annotator;

import com.google.common.io.ByteStreams;
import hudson.model.Run;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.lang.builder.ToStringBuilder;

@Immutable
class ConsoleLogParser
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long pos;

    ConsoleLogParser(long pos) {
        this.pos = pos;
    }

    public Result seek(Run<?, ?> build) throws IOException {
        long logLength = build.getLogText().length();
        if (this.pos == 0L || logLength + this.pos <= 0L) {
            Result result = new Result();
            result.atNewLine = true;
            return result;
        }
        try (BufferedInputStream inputStream = new BufferedInputStream(build.getLogInputStream());){
            if (build.isBuilding() || this.pos > 0L) {
                long posFromStart = this.pos;
                if (this.pos < 0L) {
                    posFromStart = logLength + this.pos;
                }
                Result result = this.parseFromStart(inputStream, posFromStart);
                return result;
            }
            ByteStreams.skipFully((InputStream)inputStream, (long)(logLength + this.pos - 1L));
            Result result = this.parseFromFinish((InputStream)new BoundedInputStream((InputStream)inputStream, -this.pos));
            return result;
        }
    }

    private Result parseFromStart(InputStream inputStream, long posFromStart) throws IOException {
        Result result = new Result();
        for (long i = 0L; i < posFromStart; ++i) {
            int value = inputStream.read();
            if (value == -1) {
                result.endOfFile = true;
                break;
            }
            result.atNewLine = this.isNewLine(value);
            if (!result.atNewLine) continue;
            ++result.lineNumber;
        }
        return result;
    }

    private Result parseFromFinish(InputStream inputStream) throws IOException {
        Result result = new Result();
        result.lineNumber = -1;
        int value = inputStream.read();
        result.atNewLine = this.isNewLine(value);
        while ((value = inputStream.read()) != -1) {
            if (!this.isNewLine(value)) continue;
            --result.lineNumber;
        }
        return result;
    }

    private boolean isNewLine(int character) {
        return character == 10;
    }

    static final class Result {
        int lineNumber;
        boolean atNewLine;
        boolean endOfFile;

        Result() {
        }

        public int hashCode() {
            return Objects.hash(this.lineNumber, this.atNewLine, this.endOfFile);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Result) {
                Result other = (Result)obj;
                return this.lineNumber == other.lineNumber && this.atNewLine == other.atNewLine && this.endOfFile == other.endOfFile;
            }
            return false;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("lineNumber", this.lineNumber).append("atNewLine", this.atNewLine).append("endOfFile", this.endOfFile).toString();
        }
    }
}

