/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.action;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import hudson.plugins.timestamper.Timestamp;
import hudson.plugins.timestamper.action.PrecisionTimestampFormat;
import hudson.plugins.timestamper.format.ElapsedTimestampFormat;
import hudson.plugins.timestamper.format.SystemTimestampFormat;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class TimestampsActionQuery {
    final int startLine;
    final Optional<Integer> endLine;
    final List<Function<Timestamp, String>> timestampFormats;
    final boolean appendLogLine;

    public static TimestampsActionQuery create(String query) {
        int startLine = 0;
        Optional endLine = Optional.absent();
        ArrayList<Object> timestampFormats = new ArrayList<Object>();
        boolean appendLogLine = false;
        List<QueryParameter> queryParameters = TimestampsActionQuery.readQueryString(query);
        Optional timeZoneId = Optional.absent();
        Locale locale = Locale.getDefault();
        for (QueryParameter parameter : queryParameters) {
            if (parameter.name.equalsIgnoreCase("timeZone")) {
                timeZoneId = Optional.of((Object)parameter.value.replace("GMT ", "GMT+"));
                continue;
            }
            if (!parameter.name.equalsIgnoreCase("locale")) continue;
            locale = LocaleUtils.toLocale((String)parameter.value);
        }
        for (QueryParameter parameter : queryParameters) {
            if (parameter.name.equalsIgnoreCase("time")) {
                timestampFormats.add(new SystemTimestampFormat(parameter.value, (Optional<String>)timeZoneId, locale));
                continue;
            }
            if (parameter.name.equalsIgnoreCase("elapsed")) {
                timestampFormats.add(new ElapsedTimestampFormat(parameter.value));
                continue;
            }
            if (parameter.name.equalsIgnoreCase("precision")) {
                int precision = TimestampsActionQuery.readPrecision(parameter.value);
                timestampFormats.add(new PrecisionTimestampFormat(precision));
                continue;
            }
            if (parameter.name.equalsIgnoreCase("appendLog")) {
                appendLogLine = parameter.value.isEmpty() || Boolean.parseBoolean(parameter.value);
                continue;
            }
            if (parameter.name.equalsIgnoreCase("startLine")) {
                startLine = Integer.parseInt(parameter.value);
                continue;
            }
            if (!parameter.name.equalsIgnoreCase("endLine")) continue;
            endLine = Optional.of((Object)Integer.valueOf(parameter.value));
        }
        if (timestampFormats.isEmpty()) {
            timestampFormats.add(new PrecisionTimestampFormat(3));
        }
        return new TimestampsActionQuery(startLine, (Optional<Integer>)endLine, timestampFormats, appendLogLine);
    }

    private static List<QueryParameter> readQueryString(String query) {
        ImmutableList.Builder parameters = new ImmutableList.Builder();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                String[] nameAndValue = pair.split("=", 2);
                String name = TimestampsActionQuery.urlDecode(nameAndValue[0]);
                String value = nameAndValue.length == 1 ? "" : TimestampsActionQuery.urlDecode(nameAndValue[1]);
                parameters.add((Object)new QueryParameter(name, value));
            }
        }
        return parameters.build();
    }

    private static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static int readPrecision(String precision) {
        if ("seconds".equalsIgnoreCase(precision)) {
            return 0;
        }
        if ("milliseconds".equalsIgnoreCase(precision)) {
            return 3;
        }
        if ("microseconds".equalsIgnoreCase(precision)) {
            return 6;
        }
        if ("nanoseconds".equalsIgnoreCase(precision)) {
            return 9;
        }
        int intPrecision = Integer.parseInt(precision);
        if (intPrecision < 0) {
            throw new IllegalArgumentException("Expected non-negative precision, but was: " + precision);
        }
        return intPrecision;
    }

    TimestampsActionQuery(int startLine, Optional<Integer> endLine, List<? extends Function<Timestamp, String>> timestampFormats, boolean appendLogLine) {
        this.startLine = startLine;
        this.endLine = (Optional)Preconditions.checkNotNull(endLine);
        this.timestampFormats = ImmutableList.copyOf(timestampFormats);
        this.appendLogLine = appendLogLine;
    }

    public int hashCode() {
        return Objects.hash(this.startLine, this.endLine, this.timestampFormats, this.appendLogLine);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimestampsActionQuery) {
            TimestampsActionQuery other = (TimestampsActionQuery)obj;
            return this.startLine == other.startLine && this.endLine.equals(other.endLine) && this.timestampFormats.equals(other.timestampFormats) && this.appendLogLine == other.appendLogLine;
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("startLine", this.startLine).append("endLine", this.endLine).append("timestampFormats", this.timestampFormats).append("appendLogLine", this.appendLogLine).toString();
    }

    private static class QueryParameter {
        final String name;
        final String value;

        QueryParameter(String name, String value) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.value = (String)Preconditions.checkNotNull((Object)value);
        }

        public String toString() {
            return this.name + "=" + this.value;
        }
    }
}

