/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.action;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import hudson.model.Run;
import hudson.plugins.timestamper.Timestamp;
import hudson.plugins.timestamper.action.TimestampsActionQuery;
import hudson.plugins.timestamper.io.LogFileReader;
import hudson.plugins.timestamper.io.TimestampsReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

public class TimestampsActionOutput {
    public static BufferedReader open(Run<?, ?> build, TimestampsActionQuery query) {
        TimestampsReader timestampsReader = new TimestampsReader(build);
        LogFileReader logFileReader = new LogFileReader(build);
        return TimestampsActionOutput.open(timestampsReader, logFileReader, query);
    }

    static BufferedReader open(final TimestampsReader timestampsReader, final LogFileReader logFileReader, final TimestampsActionQuery query) {
        final StringBuilder buffer = new StringBuilder();
        Reader reader = new Reader(){
            int linesRead;
            Optional<Integer> endLine = Optional.absent();
            boolean started;

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                int numRead;
                Optional<String> nextLine;
                if (!this.started) {
                    LineCountSupplier lineCount = new LineCountSupplier(logFileReader);
                    this.linesRead = this.readToStartLine(query, lineCount);
                    this.endLine = this.resolveEndLine(query, lineCount);
                    this.started = true;
                }
                while (buffer.length() < len && (nextLine = this.readNextLine(query)).isPresent()) {
                    ++this.linesRead;
                    if (this.endLine.isPresent() && this.linesRead > (Integer)this.endLine.get()) break;
                    buffer.append((String)nextLine.get());
                    buffer.append("\n");
                }
                buffer.delete(0, (numRead = new StringReader(buffer.toString()).read(cbuf, off, len)) >= 0 ? numRead : buffer.length());
                return numRead;
            }

            private int readToStartLine(TimestampsActionQuery query2, LineCountSupplier lineCount) throws IOException {
                int linesToSkip = Math.max(query2.startLine - 1, 0);
                if (query2.startLine < 0) {
                    linesToSkip = lineCount.get() + query2.startLine;
                }
                for (int line = 0; line < linesToSkip; ++line) {
                    timestampsReader.read();
                    logFileReader.nextLine();
                }
                return linesToSkip;
            }

            private Optional<Integer> resolveEndLine(TimestampsActionQuery query2, LineCountSupplier lineCount) throws IOException {
                if (query2.endLine.isPresent() && (Integer)query2.endLine.get() < 0) {
                    return Optional.of((Object)(lineCount.get() + (Integer)query2.endLine.get() + 1));
                }
                return query2.endLine;
            }

            private Optional<String> readNextLine(TimestampsActionQuery query2) throws IOException {
                Optional<Timestamp> timestamp = timestampsReader.read();
                Optional<LogFileReader.Line> logFileLine = logFileReader.nextLine();
                if (logFileLine.isPresent() && !timestamp.isPresent()) {
                    timestamp = ((LogFileReader.Line)logFileLine.get()).readTimestamp();
                }
                String result = "";
                if (timestamp.isPresent()) {
                    ArrayList<Object> parts = new ArrayList<Object>();
                    for (Function<Timestamp, String> format : query2.timestampFormats) {
                        parts.add(format.apply(timestamp.get()));
                    }
                    result = Joiner.on((char)' ').join(parts);
                }
                if (query2.appendLogLine) {
                    result = result + "  ";
                    if (logFileLine.isPresent()) {
                        result = result + ((LogFileReader.Line)logFileLine.get()).getText();
                    }
                }
                if (result.trim().isEmpty()) {
                    return Optional.absent();
                }
                return Optional.of((Object)result);
            }

            @Override
            public void close() throws IOException {
                timestampsReader.close();
                logFileReader.close();
            }
        };
        return new BufferedReader(reader);
    }

    private TimestampsActionOutput() {
    }

    private static class LineCountSupplier {
        private final LogFileReader logFileReader;
        private Optional<Integer> lineCount = Optional.absent();

        LineCountSupplier(LogFileReader logFileReader) {
            this.logFileReader = (LogFileReader)Preconditions.checkNotNull((Object)logFileReader);
        }

        int get() throws IOException {
            if (!this.lineCount.isPresent()) {
                this.lineCount = Optional.of((Object)this.logFileReader.lineCount());
            }
            return (Integer)this.lineCount.get();
        }
    }
}

