/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.action;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import hudson.model.Action;
import hudson.model.Run;
import hudson.plugins.timestamper.action.TimestampsActionOutput;
import hudson.plugins.timestamper.action.TimestampsActionQuery;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public final class TimestampsAction
implements Action {
    private static final Logger LOGGER = Logger.getLogger(TimestampsAction.class.getName());
    private final Run<?, ?> build;

    TimestampsAction(Run<?, ?> build) {
        this.build = (Run)Preconditions.checkNotNull(build);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "timestamps";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        response.setContentType("text/plain;charset=UTF-8");
        PrintWriter writer = response.getWriter();
        try {
            TimestampsActionQuery query = TimestampsActionQuery.create(request.getQueryString());
            try (BufferedReader reader = TimestampsActionOutput.open(this.build, query);){
                String line;
                while ((line = reader.readLine()) != null) {
                    writer.println(line);
                }
            }
        }
        catch (IOException | RuntimeException e) {
            String urlWithQueryString = request.getRequestURLWithQueryString().toString();
            writer.println(urlWithQueryString);
            String exceptionMessage = Strings.nullToEmpty((String)e.getMessage());
            writer.println(e.getClass().getSimpleName() + (exceptionMessage.isEmpty() ? "" : ": " + exceptionMessage));
            LOGGER.log(Level.WARNING, urlWithQueryString, e);
        }
        finally {
            writer.flush();
        }
    }
}

