/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.action;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import hudson.plugins.timestamper.Timestamp;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.lang.builder.ToStringBuilder;

final class PrecisionTimestampFormat
implements Function<Timestamp, String> {
    @Nonnegative
    private final int precision;

    PrecisionTimestampFormat(int precision) {
        Preconditions.checkArgument((precision >= 0 ? 1 : 0) != 0);
        this.precision = precision;
    }

    public String apply(@Nonnull Timestamp timestamp) {
        long seconds = timestamp.elapsedMillis / 1000L;
        if (this.precision == 0) {
            return String.valueOf(seconds);
        }
        long millis = timestamp.elapsedMillis % 1000L;
        String fractional = String.format("%03d", millis);
        fractional = this.precision <= 3 ? fractional.substring(0, this.precision) : fractional + Strings.repeat((String)"0", (int)(this.precision - 3));
        return String.valueOf(seconds) + "." + fractional;
    }

    public int hashCode() {
        return Integer.valueOf(this.precision).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PrecisionTimestampFormat) {
            PrecisionTimestampFormat other = (PrecisionTimestampFormat)obj;
            return this.precision == other.precision;
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("precision", this.precision).toString();
    }
}

