/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper;

import com.google.common.base.Preconditions;
import hudson.plugins.timestamper.io.TimestampsWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TimestamperOutputStream
extends OutputStream {
    private static final Logger LOGGER = Logger.getLogger(TimestamperOutputStream.class.getName());
    private final OutputStream delegate;
    private final TimestampsWriter timestampsWriter;
    private final byte[] oneElementByteArray = new byte[1];
    private int previousCharacter = -1;
    private boolean writeError;

    TimestamperOutputStream(OutputStream delegate, TimestampsWriter timestampsWriter) {
        this.delegate = (OutputStream)Preconditions.checkNotNull((Object)delegate);
        this.timestampsWriter = (TimestampsWriter)Preconditions.checkNotNull((Object)timestampsWriter);
    }

    @Override
    public void write(int b) throws IOException {
        this.oneElementByteArray[0] = (byte)b;
        this.writeTimestamps(this.oneElementByteArray, 0, 1);
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writeTimestamps(b, 0, b.length);
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeTimestamps(b, off, len);
        this.delegate.write(b, off, len);
    }

    private void writeTimestamps(byte[] b, int off, int len) {
        int newlineCharacter = 10;
        int lineStartCount = 0;
        for (int i = off; i < off + len; ++i) {
            if (this.previousCharacter == -1 || this.previousCharacter == newlineCharacter) {
                ++lineStartCount;
            }
            this.previousCharacter = b[i];
        }
        if (lineStartCount > 0 && !this.writeError) {
            long currentTimeMillis = System.currentTimeMillis();
            try {
                this.timestampsWriter.write(currentTimeMillis, lineStartCount);
            }
            catch (IOException ex) {
                this.writeError = true;
                LOGGER.log(Level.WARNING, "Error writing timestamps", ex);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.timestampsWriter.close();
            if (!this.writeError) {
                this.timestampsWriter.writeDigest();
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
        this.delegate.close();
    }
}

