/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper;

import hudson.Extension;
import hudson.model.Descriptor;
import javax.annotation.CheckForNull;
import jenkins.YesNoMaybe;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

@Extension(dynamicLoadable=YesNoMaybe.YES)
public final class TimestamperConfig
extends GlobalConfiguration {
    private static final String DEFAULT_TIMESTAMP_FORMAT = "'<b>'HH:mm:ss'</b> '";
    private static final String DEFAULT_ELAPSED_TIME_FORMAT = "'<b>'HH:mm:ss.S'</b> '";
    @CheckForNull
    private String timestampFormat;
    @CheckForNull
    private String elapsedTimeFormat;

    public static TimestamperConfig get() {
        TimestamperConfig config;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null && (config = (TimestamperConfig)jenkins.getDescriptorByType(TimestamperConfig.class)) != null) {
            return config;
        }
        return null;
    }

    public TimestamperConfig() {
        this.load();
    }

    public String getSystemTimeFormat() {
        return this.timestampFormat == null ? DEFAULT_TIMESTAMP_FORMAT : this.timestampFormat;
    }

    public void setSystemTimeFormat(@CheckForNull String timestampFormat) {
        this.timestampFormat = timestampFormat;
    }

    public String getElapsedTimeFormat() {
        return this.elapsedTimeFormat == null ? DEFAULT_ELAPSED_TIME_FORMAT : this.elapsedTimeFormat;
    }

    public void setElapsedTimeFormat(@CheckForNull String elapsedTimeFormat) {
        this.elapsedTimeFormat = elapsedTimeFormat;
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }
}

