/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper;

import com.google.common.base.Optional;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.timestamper.Messages;
import hudson.plugins.timestamper.TimestampNote;
import hudson.plugins.timestamper.TimestampNotesOutputStream;
import hudson.plugins.timestamper.TimestamperOutputStream;
import hudson.plugins.timestamper.io.TimestamperPaths;
import hudson.plugins.timestamper.io.TimestampsWriter;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.YesNoMaybe;
import jenkins.tasks.SimpleBuildWrapper;
import org.kohsuke.stapler.DataBoundConstructor;

public final class TimestamperBuildWrapper
extends SimpleBuildWrapper {
    private static final Logger LOGGER = Logger.getLogger(TimestamperBuildWrapper.class.getName());

    @DataBoundConstructor
    public TimestamperBuildWrapper() {
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
    }

    public ConsoleLogFilter createLoggerDecorator(Run<?, ?> build) {
        return new ConsoleLogFilterImpl(build);
    }

    @Extension(dynamicLoadable=YesNoMaybe.YES)
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return Messages.Description();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }

    private static class ConsoleLogFilterImpl
    extends ConsoleLogFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final File timestampsFile;
        private final long buildStartTime;
        private final boolean useTimestampNotes;

        ConsoleLogFilterImpl(Run<?, ?> build) {
            this.timestampsFile = TimestamperPaths.timestampsFile(build);
            this.buildStartTime = build.getStartTimeInMillis();
            this.useTimestampNotes = !(build instanceof AbstractBuild) || Boolean.getBoolean(TimestampNote.getSystemProperty());
        }

        public OutputStream decorateLogger(AbstractBuild _ignore, OutputStream logger) throws IOException, InterruptedException {
            if (this.useTimestampNotes) {
                return new TimestampNotesOutputStream(logger, this.buildStartTime);
            }
            Optional digest = Optional.absent();
            try {
                digest = Optional.of((Object)MessageDigest.getInstance("SHA-1"));
            }
            catch (NoSuchAlgorithmException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
            try {
                TimestampsWriter timestampsWriter = new TimestampsWriter(this.timestampsFile, this.buildStartTime, (Optional<MessageDigest>)digest);
                logger = new TimestamperOutputStream(logger, timestampsWriter);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
            return logger;
        }
    }
}

