/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper;

import com.google.common.base.Preconditions;
import hudson.console.LineTransformationOutputStream;
import hudson.plugins.timestamper.TimestampNote;
import java.io.IOException;
import java.io.OutputStream;

public class TimestampNotesOutputStream
extends LineTransformationOutputStream {
    private final OutputStream delegate;
    private final long buildStartTime;

    public TimestampNotesOutputStream(OutputStream delegate, long buildStartTime) {
        this.delegate = (OutputStream)Preconditions.checkNotNull((Object)delegate);
        this.buildStartTime = buildStartTime;
    }

    protected void eol(byte[] b, int len) throws IOException {
        long now = System.currentTimeMillis();
        new TimestampNote(now - this.buildStartTime, now).encodeTo(this.delegate);
        this.delegate.write(b, 0, len);
    }

    public void close() throws IOException {
        super.close();
        this.delegate.close();
    }
}

