/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.orgfolder.github;

import hudson.model.Item;
import hudson.model.Job;
import hudson.util.DescribableList;
import jenkins.branch.Branch;
import jenkins.branch.OrganizationFolder;
import jenkins.scm.api.SCMNavigator;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigator;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;

class Sniffer {
    Sniffer() {
    }

    public static OrgMatch matchOrg(Object item) {
        SCMNavigator n;
        OrganizationFolder of;
        DescribableList navigators;
        if (item instanceof OrganizationFolder && (navigators = (of = (OrganizationFolder)item).getNavigators()) != null && navigators.size() > 0 && (n = (SCMNavigator)navigators.get(0)) instanceof GitHubSCMNavigator) {
            return new OrgMatch(of, (GitHubSCMNavigator)n);
        }
        return null;
    }

    public static RepoMatch matchRepo(Object item) {
        WorkflowMultiBranchProject repo;
        OrgMatch org;
        if (item instanceof WorkflowMultiBranchProject && (org = Sniffer.matchOrg((repo = (WorkflowMultiBranchProject)item).getParent())) != null) {
            return new RepoMatch(org, repo);
        }
        return null;
    }

    public static BranchMatch matchBranch(Item item) {
        if (item instanceof WorkflowJob) {
            WorkflowJob branch = (WorkflowJob)item;
            RepoMatch x = Sniffer.matchRepo(item.getParent());
            if (x != null) {
                return new BranchMatch(x, branch);
            }
        }
        return null;
    }

    static class BranchMatch
    extends RepoMatch {
        final WorkflowJob branch;

        public BranchMatch(RepoMatch x, WorkflowJob branch) {
            super(x, x.repo);
            this.branch = branch;
        }

        public Branch getScmBranch() {
            return this.repo.getProjectFactory().getBranch((Job)this.branch);
        }
    }

    static class RepoMatch
    extends OrgMatch {
        final WorkflowMultiBranchProject repo;

        public RepoMatch(OrgMatch x, WorkflowMultiBranchProject repo) {
            super(x.folder, x.scm);
            this.repo = repo;
        }
    }

    static class OrgMatch {
        final OrganizationFolder folder;
        final GitHubSCMNavigator scm;

        public OrgMatch(OrganizationFolder folder, GitHubSCMNavigator scm) {
            this.folder = folder;
            this.scm = scm;
        }
    }
}

