/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.orgfolder.github;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.google.common.collect.Sets;
import hudson.Extension;
import hudson.model.Job;
import hudson.security.ACL;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import jenkins.branch.OrganizationFolder;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.SCMSourceOwners;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigator;
import org.kohsuke.github.GHEvent;

@Extension
public class RepositoryGHEventSubscriber
extends GHEventsSubscriber {
    private static final Logger LOGGER = Logger.getLogger(RepositoryGHEventSubscriber.class.getName());
    private static final Pattern REPOSITORY_NAME_PATTERN = Pattern.compile("https?://([^/]+)/([^/]+)/([^/]+)");

    protected boolean isApplicable(@Nullable Job<?, ?> project) {
        return true;
    }

    protected Set<GHEvent> events() {
        return Sets.immutableEnumSet((Enum)GHEvent.REPOSITORY, (Enum[])new GHEvent[0]);
    }

    protected void onEvent(GHEvent event, String payload) {
        JSONObject json = JSONObject.fromObject((Object)payload);
        String repoUrl = json.getJSONObject("repository").getString("html_url");
        boolean fork = json.getJSONObject("repository").getBoolean("fork");
        LOGGER.log(Level.FINE, "Received REPOSITORY_EVENT for {0}", repoUrl);
        Matcher matcher = REPOSITORY_NAME_PATTERN.matcher(repoUrl);
        if (matcher.matches()) {
            final GitHubRepositoryName repo = GitHubRepositoryName.create((String)repoUrl);
            if (repo == null) {
                LOGGER.log(Level.WARNING, "Malformed repository URL {0}", repoUrl);
                return;
            }
            if (!fork) {
                LOGGER.log(Level.FINE, "Repository {0} was created but it is empty, will be ignored", repo.getRepositoryName());
                return;
            }
            ACL.impersonate((Authentication)ACL.SYSTEM, (Runnable)new Runnable(){

                @Override
                public void run() {
                    for (SCMSourceOwner owner : SCMSourceOwners.all()) {
                        if (!(owner instanceof OrganizationFolder)) continue;
                        OrganizationFolder orgFolder = (OrganizationFolder)owner;
                        for (GitHubSCMNavigator navigator : orgFolder.getNavigators().getAll(GitHubSCMNavigator.class)) {
                            if (!Pattern.matches(navigator.getPattern(), repo.getRepositoryName())) continue;
                            orgFolder.scheduleBuild();
                        }
                    }
                }
            });
        } else {
            LOGGER.log(Level.WARNING, "Malformed repository URL {0}", repoUrl);
        }
    }
}

