/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.orgfolder.github;

import com.cloudbees.hudson.plugins.folder.FolderIcon;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.BulkChange;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.AllView;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.Saveable;
import hudson.model.View;
import hudson.util.DescribableList;
import hudson.views.JobColumn;
import hudson.views.ListViewColumn;
import hudson.views.StatusColumn;
import hudson.views.WeatherColumn;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.branch.Branch;
import jenkins.branch.OrganizationFolder;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.actions.ChangeRequestAction;
import jenkins.util.io.FileBoolean;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigator;
import org.jenkinsci.plugins.github_branch_source.RateLimitExceededException;
import org.jenkinsci.plugins.orgfolder.github.BranchJobFilter;
import org.jenkinsci.plugins.orgfolder.github.CustomNameJobColumn;
import org.jenkinsci.plugins.orgfolder.github.GitHubLink;
import org.jenkinsci.plugins.orgfolder.github.GitHubOrgAction;
import org.jenkinsci.plugins.orgfolder.github.GitHubOrgIcon;
import org.jenkinsci.plugins.orgfolder.github.GitHubRepoAction;
import org.jenkinsci.plugins.orgfolder.github.GitHubRepoIcon;
import org.jenkinsci.plugins.orgfolder.github.Messages;
import org.jenkinsci.plugins.orgfolder.github.PullRequestJobFilter;
import org.jenkinsci.plugins.orgfolder.github.RepositoryDescriptionColumn;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHHook;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;

@Extension
public class MainLogic {
    private final ThreadLocal<Set<Item>> UPDATING = new ThreadLocal<Set<Item>>(){

        @Override
        protected Set<Item> initialValue() {
            return new HashSet<Item>();
        }
    };
    private static final Logger LOGGER = Logger.getLogger(MainLogic.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyOrg(OrganizationFolder of, GitHubSCMNavigator scm) throws IOException {
        if (this.UPDATING.get().add((Item)of)) {
            BulkChange bc = new BulkChange((Saveable)of);
            try {
                FileBoolean orghook;
                GitHub hub = this.connect((SCMSourceOwner)of, scm);
                GHUser u = hub.getUser(scm.getRepoOwner());
                of.setIcon((FolderIcon)new GitHubOrgIcon());
                of.replaceAction((Action)new GitHubOrgAction(u));
                of.replaceAction((Action)new GitHubLink("logo", u.getHtmlUrl()));
                if (of.getDisplayNameOrNull() == null) {
                    of.setDisplayName(u.getName());
                }
                if (of.getView("Repositories") == null && of.getView("All") instanceof AllView) {
                    ListView lv = new ListView("Repositories");
                    lv.getColumns().replaceBy(Arrays.asList(new ListViewColumn[]{new StatusColumn(), new WeatherColumn(), new CustomNameJobColumn(Messages.class, Messages._ListViewColumn_Repository()), new RepositoryDescriptionColumn()}));
                    lv.setIncludeRegex(".*");
                    of.addView((View)lv);
                    of.deleteView(of.getView("All"));
                    of.setPrimaryView((View)lv);
                }
                if ((orghook = new FileBoolean(new File(of.getRootDir(), "GitHubOrgHook." + scm.getRepoOwner()))).isOff()) {
                    try {
                        GHOrganization org = hub.getOrganization(scm.getRepoOwner());
                        String url = Jenkins.getActiveInstance().getRootUrl() + "github-webhook/";
                        if (!this.existsHook(org, url)) {
                            org.createWebHook(new URL(url), Arrays.asList(GHEvent.REPOSITORY, GHEvent.PUSH));
                            LOGGER.log(Level.INFO, "A webhook was registered for the organization {0}", org.getHtmlUrl());
                        }
                        orghook.on();
                    }
                    catch (FileNotFoundException e) {
                        LOGGER.log(Level.WARNING, "Failed to register GitHub Org hook to {0} (missing permissions?): {1}", new Object[]{u.getHtmlUrl(), e.getMessage()});
                        LOGGER.log(Level.FINE, null, e);
                    }
                    catch (RateLimitExceededException e) {
                        LOGGER.log(Level.WARNING, "Failed to register GitHub Org hook to {0}: {1}", new Object[]{u.getHtmlUrl(), e.getMessage()});
                        LOGGER.log(Level.FINE, null, e);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to register GitHub Org hook to " + u.getHtmlUrl(), e);
                    }
                }
                bc.commit();
            }
            finally {
                bc.abort();
                this.UPDATING.get().remove(of);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyRepo(WorkflowMultiBranchProject item, GitHubSCMNavigator scm) throws IOException {
        if (this.UPDATING.get().add((Item)item)) {
            BulkChange bc = new BulkChange((Saveable)item);
            try {
                GitHub hub = this.connect((SCMSourceOwner)item, scm);
                GHRepository repo = hub.getRepository(scm.getRepoOwner() + '/' + item.getName());
                item.setIcon((FolderIcon)new GitHubRepoIcon());
                item.replaceAction((Action)new GitHubRepoAction(repo));
                item.replaceAction((Action)new GitHubLink("repo", repo.getHtmlUrl()));
                if (item.getView("Branches") == null && item.getView("All") instanceof AllView) {
                    ListView bv = new ListView("Branches");
                    DescribableList cols = bv.getColumns();
                    JobColumn name = (JobColumn)cols.get(JobColumn.class);
                    if (name != null) {
                        cols.replace((Object)name, (Object)new CustomNameJobColumn(Messages.class, Messages._ListViewColumn_Branch()));
                    }
                    bv.getJobFilters().add((Object)new BranchJobFilter());
                    ListView pv = new ListView("Pull Requests");
                    cols = pv.getColumns();
                    name = (JobColumn)cols.get(JobColumn.class);
                    if (name != null) {
                        cols.replace((Object)name, (Object)new CustomNameJobColumn(Messages.class, Messages._ListViewColumn_PullRequest()));
                    }
                    pv.getJobFilters().add((Object)new PullRequestJobFilter());
                    item.addView((View)bv);
                    item.addView((View)pv);
                    item.deleteView(item.getView("All"));
                    item.setPrimaryView((View)bv);
                }
                bc.commit();
            }
            finally {
                bc.abort();
                this.UPDATING.get().remove(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyBranch(WorkflowJob branch, WorkflowMultiBranchProject repo, GitHubSCMNavigator scm) throws IOException {
        if (this.UPDATING.get().add((Item)branch)) {
            BulkChange bc = new BulkChange((Saveable)branch);
            try {
                Branch b = repo.getProjectFactory().getBranch((Job)branch);
                GitHubLink repoLink = (GitHubLink)repo.getAction(GitHubLink.class);
                if (repoLink != null) {
                    ChangeRequestAction action = (ChangeRequestAction)b.getHead().getAction(ChangeRequestAction.class);
                    String url = action == null ? repoLink.getUrl() + "/tree/" + b.getName() : repoLink.getUrl() + "/pull/" + action.getId();
                    branch.replaceAction((Action)new GitHubLink("branch", url));
                    bc.commit();
                }
            }
            finally {
                bc.abort();
                this.UPDATING.get().remove(branch);
            }
        }
    }

    GitHub connect(SCMSourceOwner of, GitHubSCMNavigator n) throws IOException {
        StandardCredentials credentials = Connector.lookupScanCredentials((SCMSourceOwner)of, (String)n.getApiUri(), (String)n.getScanCredentialsId());
        return Connector.connect((String)n.getApiUri(), (StandardCredentials)credentials);
    }

    private boolean existsHook(GHOrganization org, String url) throws IOException {
        for (GHHook hook : org.getHooks()) {
            if (!((String)hook.getConfig().get("url")).equals(url)) continue;
            return true;
        }
        return false;
    }

    public static MainLogic get() {
        return (MainLogic)Jenkins.getActiveInstance().getInjector().getInstance(MainLogic.class);
    }
}

