/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.orgfolder.github;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jenkinsci.plugins.orgfolder.github.MainLogic;
import org.jenkinsci.plugins.orgfolder.github.Sniffer;

@Extension
public class ItemListenerImpl
extends ItemListener {
    @Inject
    private MainLogic main;
    private static final Logger LOGGER = Logger.getLogger(ItemListenerImpl.class.getName());

    public void onUpdated(Item item) {
        this.maybeApply(item);
    }

    public void onCreated(Item item) {
        this.maybeApply(item);
    }

    private void maybeApply(Item item) {
        try {
            Sniffer.BranchMatch b;
            Sniffer.RepoMatch r;
            Sniffer.OrgMatch f = Sniffer.matchOrg(item);
            if (f != null) {
                this.main.applyOrg(f.folder, f.scm);
            }
            if ((r = Sniffer.matchRepo(item)) != null) {
                this.main.applyRepo(r.repo, r.scm);
            }
            if ((b = Sniffer.matchBranch(item)) != null) {
                this.main.applyBranch(b.branch, b.repo, b.scm);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.FINE, "Failed to apply GitHub Org Folder theme to " + item.getFullName() + " because the Org does not exists or it's not accessible", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to apply GitHub Org Folder theme to " + item.getFullName(), e);
        }
    }
}

