/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.orgfolder.github;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.FolderIcon;
import com.cloudbees.hudson.plugins.folder.FolderIconDescriptor;
import hudson.Extension;
import hudson.model.Hudson;
import org.jenkinsci.plugins.orgfolder.github.GitHubOrgAction;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;

public class GitHubOrgIcon
extends FolderIcon {
    private AbstractFolder<?> folder;

    @DataBoundConstructor
    public GitHubOrgIcon() {
    }

    protected void setOwner(AbstractFolder<?> folder) {
        this.folder = folder;
    }

    public String getImageOf(String s) {
        String url = this.getAvatarUrl();
        if (url == null) {
            return Stapler.getCurrentRequest().getContextPath() + Hudson.RESOURCE_PATH + "/plugin/github-organization-folder/images/logo/" + s + ".png";
        }
        String[] xy = s.split("x");
        if (xy.length == 0) {
            return url;
        }
        if (url.contains("?")) {
            return url + "&s=" + xy[0];
        }
        return url + "?s=" + xy[0];
    }

    public String getDescription() {
        return this.folder != null ? this.folder.getName() : "GitHub";
    }

    private String getAvatarUrl() {
        if (this.folder == null) {
            return null;
        }
        GitHubOrgAction p = (GitHubOrgAction)this.folder.getAction(GitHubOrgAction.class);
        if (p == null) {
            return null;
        }
        return p.getAvatar();
    }

    @Extension
    public static class DescriptorImpl
    extends FolderIconDescriptor {
        public String getDisplayName() {
            return "GitHub Organization Avatar";
        }
    }
}

