/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.orgfolder.github;

import hudson.Extension;
import hudson.views.JobColumn;
import hudson.views.ListViewColumnDescriptor;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.NonLocalizable;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;

public class CustomNameJobColumn
extends JobColumn {
    private final String bundle;
    private final String key;
    private transient Localizable loc;
    private static final Logger LOGGER = Logger.getLogger(CustomNameJobColumn.class.getName());

    @DataBoundConstructor
    public CustomNameJobColumn(String bundle, String key) {
        this.bundle = bundle;
        this.key = key;
        this.readResolve();
    }

    public CustomNameJobColumn(Class bundle, Localizable loc) {
        this.bundle = bundle.getName();
        this.key = loc.getKey();
        this.loc = loc;
    }

    private Object readResolve() {
        try {
            this.loc = new Localizable(ResourceBundleHolder.get(Jenkins.getActiveInstance().pluginManager.uberClassLoader.loadClass(this.bundle)), this.key, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.WARNING, "No such bundle: " + this.bundle);
            this.loc = new NonLocalizable(this.bundle + ':' + this.key);
        }
        return this;
    }

    public String getBundle() {
        return this.bundle;
    }

    public String getKey() {
        return this.key;
    }

    public String getMessage() {
        return this.loc.toString();
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return "Job Name with Custom Title";
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

