/*
 * Decompiled with CFR 0.152.
 */
package net.java.sezpoz.impl;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.java.sezpoz.impl.SerAnnotatedElement;

public class Inspector {
    private static final byte[] ZIP_MAGIC = new byte[]{80, 75, 3, 4};
    private static final byte[] SER_MAGIC = new byte[]{-84, -19, 0, 5};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Usage: java -jar sezpoz.jar [ something.jar | some.serialized.Annotation ]+");
        }
        for (String arg : args) {
            System.out.println("--- " + arg);
            byte[] magic = new byte[4];
            InputStream is = new FileInputStream(arg);
            try {
                is.read(magic, 0, 4);
            }
            finally {
                is.close();
            }
            if (Arrays.equals(magic, ZIP_MAGIC)) {
                JarFile jf = new JarFile(arg, false);
                try {
                    Enumeration<JarEntry> entries = jf.entries();
                    while (entries.hasMoreElements()) {
                        String annotation;
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (!name.startsWith("META-INF/annotations/") || (annotation = name.substring("META-INF/annotations/".length())).isEmpty() || annotation.endsWith(".txt")) continue;
                        System.out.println("# " + annotation);
                        is = jf.getInputStream(entry);
                        try {
                            is.read(magic, 0, 4);
                        }
                        finally {
                            is.close();
                        }
                        if (Arrays.equals(magic, SER_MAGIC)) {
                            is = jf.getInputStream(entry);
                            try {
                                Inspector.dump(is);
                                continue;
                            }
                            finally {
                                is.close();
                                continue;
                            }
                        }
                        System.err.println("does not look like a Java serialized file");
                    }
                    continue;
                }
                finally {
                    jf.close();
                }
            }
            if (Arrays.equals(magic, SER_MAGIC)) {
                is = new FileInputStream(arg);
                try {
                    Inspector.dump(is);
                    continue;
                }
                finally {
                    is.close();
                }
            }
            System.err.println("does not look like either a JAR file or a Java serialized file");
        }
    }

    private static void dump(InputStream is) throws Exception {
        SerAnnotatedElement el;
        ObjectInputStream oi = new ObjectInputStream(is);
        while ((el = (SerAnnotatedElement)oi.readObject()) != null) {
            System.out.println(el);
        }
    }
}

