/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import hudson.scm.SCMDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.MultiBranchProjectDescriptor;
import jenkins.model.TransientActionFactory;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import org.jenkinsci.plugins.workflow.cps.Snippetizer;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.AbstractWorkflowBranchProjectFactory;
import org.jenkinsci.plugins.workflow.multibranch.Messages;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowBranchProjectFactory;

public class WorkflowMultiBranchProject
extends MultiBranchProject<WorkflowJob, WorkflowRun> {
    private static final Logger LOGGER = Logger.getLogger(WorkflowMultiBranchProject.class.getName());

    public WorkflowMultiBranchProject(ItemGroup parent, String name) {
        super(parent, name);
    }

    protected BranchProjectFactory<WorkflowJob, WorkflowRun> newProjectFactory() {
        return new WorkflowBranchProjectFactory();
    }

    public SCMSourceCriteria getSCMSourceCriteria(SCMSource source) {
        return ((AbstractWorkflowBranchProjectFactory)this.getProjectFactory()).getSCMSourceCriteria(source);
    }

    @Extension
    public static class PerFolderAdder
    extends TransientActionFactory<WorkflowMultiBranchProject> {
        public Class<WorkflowMultiBranchProject> type() {
            return WorkflowMultiBranchProject.class;
        }

        public Collection<? extends Action> createFor(WorkflowMultiBranchProject target) {
            if (target.hasPermission(Item.EXTENDED_READ)) {
                return Collections.singleton(new Snippetizer.LocalAction());
            }
            return Collections.emptySet();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends MultiBranchProjectDescriptor {
        public String getDisplayName() {
            return Messages.WorkflowMultiBranchProject_DisplayName();
        }

        public String getDescription() {
            return Messages.WorkflowMultiBranchProject_Description();
        }

        public String getIconFilePathPattern() {
            return "plugin/workflow-multibranch/images/:size/pipelinemultibranchproject.png";
        }

        public TopLevelItem newInstance(ItemGroup parent, String name) {
            return new WorkflowMultiBranchProject(parent, name);
        }

        public boolean isApplicable(Descriptor descriptor) {
            if (descriptor instanceof SCMDescriptor) {
                SCMDescriptor d = (SCMDescriptor)descriptor;
                try {
                    if (!d.isApplicable((Job)new WorkflowJob(null, null))) {
                        return false;
                    }
                }
                catch (RuntimeException x) {
                    LOGGER.log(Level.FINE, "SCMDescriptor.isApplicable hack failed", x);
                }
            }
            return super.isApplicable(descriptor);
        }
    }
}

