/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import hudson.AbortException;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import jenkins.branch.BuildRetentionBranchProperty;
import jenkins.branch.RateLimitBranchProperty;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;
import org.jenkinsci.plugins.workflow.multibranch.Messages;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class JobPropertyStep
extends AbstractStepImpl {
    private final List<JobProperty> properties;

    @DataBoundConstructor
    public JobPropertyStep(List<JobProperty> properties) {
        this.properties = properties;
    }

    public List<JobProperty> getProperties() {
        return this.properties;
    }

    public Map<JobPropertyDescriptor, JobProperty> getPropertiesMap() {
        return Descriptor.toMap(this.properties);
    }

    @Extension
    public static class HideSuperfluousBranchProperties
    extends DescriptorVisibilityFilter {
        public boolean filter(Object context, Descriptor descriptor) {
            return !(context instanceof WorkflowMultiBranchProject) || descriptor.clazz != RateLimitBranchProperty.class && descriptor.clazz != BuildRetentionBranchProperty.class;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "properties";
        }

        public String getDisplayName() {
            return "Set job properties";
        }

        public Step newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (req == null) {
                return (Step)super.newInstance(null, formData);
            }
            ArrayList<JobProperty> properties = new ArrayList<JobProperty>();
            ClassLoader cl = req.getStapler().getWebApp().getClassLoader();
            Set entrySet = formData.getJSONObject("propertiesMap").entrySet();
            for (Map.Entry e : entrySet) {
                JSONObject more;
                Class<JobProperty> itemType;
                if (!(e.getValue() instanceof JSONObject)) continue;
                String className = ((String)e.getKey()).replace('-', '.');
                try {
                    itemType = cl.loadClass(className).asSubclass(JobProperty.class);
                }
                catch (ClassNotFoundException x) {
                    throw new Descriptor.FormException((Throwable)x, "propertiesMap");
                }
                JobPropertyDescriptor d = (JobPropertyDescriptor)Jenkins.getActiveInstance().getDescriptorOrDie(itemType);
                JobProperty property = d.newInstance(req, more = (JSONObject)e.getValue());
                if (property == null) continue;
                properties.add(property);
            }
            return new JobPropertyStep(properties);
        }

        @Restricted(value={DoNotUse.class})
        public Collection<? extends Descriptor<?>> getPropertyDescriptors() {
            ArrayList<JobPropertyDescriptor> result = new ArrayList<JobPropertyDescriptor>();
            for (JobPropertyDescriptor p : ExtensionList.lookup(JobPropertyDescriptor.class)) {
                if (!p.isApplicable(WorkflowJob.class)) continue;
                result.add(p);
            }
            return result;
        }
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<Void> {
        @Inject
        transient JobPropertyStep step;
        @StepContextParameter
        transient Run<?, ?> build;
        @StepContextParameter
        transient TaskListener l;
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void run() throws Exception {
            Job job = this.build.getParent();
            boolean isMultibranch = this.isMultibranch(job);
            for (JobProperty prop : this.step.properties) {
                if (prop.getDescriptor().isApplicable(job.getClass())) continue;
                throw new AbortException("cannot apply " + prop.getDescriptor().getId() + " to a " + job.getClass().getSimpleName());
            }
            BulkChange bc = new BulkChange((Saveable)job);
            try {
                if (!isMultibranch) {
                    this.l.getLogger().println(Messages.JobPropertyStep__could_remove_warning());
                }
                for (JobProperty prop : job.getAllProperties()) {
                    if (prop instanceof BranchJobProperty) continue;
                    if (!isMultibranch) {
                        this.l.getLogger().println(Messages.JobPropertyStep__removed_property_warning(prop.getDescriptor().getDisplayName()));
                    }
                    job.removeProperty(prop);
                }
                for (JobProperty prop : this.step.properties) {
                    job.addProperty(prop);
                }
                bc.commit();
            }
            finally {
                bc.abort();
            }
            return null;
        }

        private boolean isMultibranch(Job<?, ?> job) {
            return job.getParent() instanceof WorkflowMultiBranchProject;
        }
    }
}

