/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.sshd;

import com.trilead.ssh2.crypto.Base64;
import com.trilead.ssh2.packets.TypesWriter;
import hudson.model.User;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.logging.Logger;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.jenkinsci.main.modules.cli.auth.ssh.UserPropertyImpl;

class PublicKeyAuthenticatorImpl
implements PublickeyAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(PublicKeyAuthenticatorImpl.class.getName());

    PublicKeyAuthenticatorImpl() {
    }

    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        LOGGER.fine("Authentication attempted from " + username + " with " + key);
        User u = User.get((String)username, (boolean)false);
        if (u == null) {
            LOGGER.fine("No such user exists: " + username);
            return false;
        }
        UserPropertyImpl sshKey = (UserPropertyImpl)u.getProperty(UserPropertyImpl.class);
        if (sshKey == null) {
            LOGGER.fine("No SSH key registered for user: " + username);
            return false;
        }
        if (!sshKey.isAuthorizedKey(PublicKeyAuthenticatorImpl.getPublicKeySignature(key))) {
            LOGGER.fine("Key signature didn't match for the user: " + username + " : " + PublicKeyAuthenticatorImpl.getPublicKeySignature(key));
            return false;
        }
        return true;
    }

    private static String getPublicKeySignature(PublicKey pk) {
        TypesWriter tw = new TypesWriter();
        if (pk instanceof RSAPublicKey) {
            RSAPublicKey rpk = (RSAPublicKey)pk;
            tw.writeString("ssh-rsa");
            tw.writeMPInt(rpk.getPublicExponent());
            tw.writeMPInt(rpk.getModulus());
            return new String(Base64.encode((byte[])tw.getBytes()));
        }
        if (pk instanceof DSAPublicKey) {
            DSAPublicKey rpk = (DSAPublicKey)pk;
            tw.writeString("ssh-dss");
            DSAParams p = rpk.getParams();
            tw.writeMPInt(p.getP());
            tw.writeMPInt(p.getQ());
            tw.writeMPInt(p.getG());
            tw.writeMPInt(rpk.getY());
            return new String(Base64.encode((byte[])tw.getBytes()));
        }
        throw new IllegalArgumentException("Unknown key type: " + pk);
    }
}

