/*
 * Decompiled with CFR 0.152.
 */
package com.iwombat.foundation.uuid;

import com.iwombat.foundation.Identifier;
import com.iwombat.util.HexStringUtil;
import java.io.Serializable;

public class UUID
implements Identifier,
Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] value = new byte[16];
    private static final int UUID_LEN = 16;

    protected UUID(byte[] value) {
        this.setValue(value);
    }

    protected UUID(String hexString) {
        if (32 != hexString.length()) {
            throw new IllegalArgumentException("Invalid UUID Length of :" + hexString.length() + "  String:" + hexString);
        }
        byte[] idBytes = HexStringUtil.bytesFromHexString(hexString);
        this.setValue(idBytes);
    }

    public byte[] getValue() {
        return this.value;
    }

    protected void setValue(byte[] newValue) {
        if (16 != newValue.length) {
            throw new IllegalArgumentException("Invalid UUID Length of :" + newValue.length);
        }
        this.value = newValue;
    }

    public String toHexString() {
        return HexStringUtil.stringFromBytes(this.getValue());
    }

    public String toString() {
        return this.toHexString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UUID)) {
            return false;
        }
        byte[] otherBinaryValue = ((UUID)obj).getValue();
        byte[] myBinaryValue = this.getValue();
        for (int counter = 0; counter < 16; ++counter) {
            if (otherBinaryValue[counter] == myBinaryValue[counter]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.toHexString().hashCode();
    }
}

