/*
 * Decompiled with CFR 0.152.
 */
package hudson.os.windows;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.util.StreamCopyThread;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import org.jinterop.dcom.common.JIException;
import org.jvnet.hudson.remcom.WindowsRemoteProcessLauncher;

public class WindowsRemoteLauncher
extends Launcher {
    private final WindowsRemoteProcessLauncher launcher;

    public WindowsRemoteLauncher(TaskListener listener, WindowsRemoteProcessLauncher launcher) {
        super(listener, null);
        this.launcher = launcher;
    }

    private String buildCommandLine(Launcher.ProcStarter ps) {
        StringBuilder b = new StringBuilder();
        for (String cmd : ps.cmds()) {
            if (b.length() > 0) {
                b.append(' ');
            }
            if (cmd.indexOf(32) >= 0) {
                b.append('\"').append(cmd).append('\"');
                continue;
            }
            b.append(cmd);
        }
        return b.toString();
    }

    public Proc launch(Launcher.ProcStarter ps) throws IOException {
        Process proc;
        this.maskedPrintCommandLine(ps.cmds(), ps.masks(), ps.pwd());
        String name = ps.cmds().toString();
        try {
            proc = this.launcher.launch(this.buildCommandLine(ps), ps.pwd().getRemote());
        }
        catch (JIException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        StreamCopyThread t1 = new StreamCopyThread("stdout copier: " + name, proc.getInputStream(), ps.stdout(), false);
        t1.start();
        StreamCopyThread t2 = new StreamCopyThread("stdin copier: " + name, ps.stdin(), proc.getOutputStream(), true);
        t2.start();
        return new Proc((Thread)t1, (Thread)t2){
            final /* synthetic */ Thread val$t1;
            final /* synthetic */ Thread val$t2;
            {
                this.val$t1 = thread;
                this.val$t2 = thread2;
            }

            public boolean isAlive() throws IOException, InterruptedException {
                try {
                    proc.exitValue();
                    return false;
                }
                catch (IllegalThreadStateException e) {
                    return true;
                }
            }

            public void kill() throws IOException, InterruptedException {
                this.val$t1.interrupt();
                this.val$t2.interrupt();
                proc.destroy();
            }

            public int join() throws IOException, InterruptedException {
                try {
                    this.val$t1.join();
                    this.val$t2.join();
                    int n = proc.waitFor();
                    return n;
                }
                finally {
                    proc.destroy();
                }
            }

            public InputStream getStdout() {
                throw new UnsupportedOperationException();
            }

            public InputStream getStderr() {
                throw new UnsupportedOperationException();
            }

            public OutputStream getStdin() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Channel launchChannel(String[] cmd, OutputStream out, FilePath _workDir, Map<String, String> envVars) throws IOException, InterruptedException {
        this.printCommandLine(cmd, _workDir);
        try {
            Process proc = this.launcher.launch(Util.join(Arrays.asList(cmd), (String)" "), _workDir.getRemote());
            return new Channel("channel over named pipe to " + this.launcher.getHostName(), Computer.threadPoolForRemoting, proc.getInputStream(), (OutputStream)new BufferedOutputStream(proc.getOutputStream()));
        }
        catch (JIException e) {
            throw new IOException(e);
        }
    }

    public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
    }
}

