/*
 * Decompiled with CFR 0.152.
 */
package hudson.os.windows;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.os.windows.ManagedWindowsServiceAccount;
import hudson.os.windows.Messages;
import hudson.os.windows.WindowsRemoteFileSystem;
import hudson.os.windows.WindowsRemoteLauncher;
import hudson.remoting.Channel;
import hudson.remoting.SocketInputStream;
import hudson.remoting.SocketOutputStream;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.slaves.SlaveComputer;
import hudson.tools.JDKInstaller;
import hudson.util.DescribableList;
import hudson.util.Secret;
import hudson.util.jna.DotNet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.jinterop.dcom.common.IJIAuthInfo;
import org.jinterop.dcom.common.JIDefaultAuthInfoImpl;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.JISession;
import org.jvnet.hudson.remcom.WindowsRemoteProcessLauncher;
import org.jvnet.hudson.wmi.SWbemServices;
import org.jvnet.hudson.wmi.WMI;
import org.jvnet.hudson.wmi.Win32Service;
import org.kohsuke.stapler.DataBoundConstructor;

public class ManagedWindowsServiceLauncher
extends ComputerLauncher {
    public final String userName;
    public final Secret password;
    public final String vmargs;
    public final String javaPath;
    public final transient AccountInfo logOn;
    private ManagedWindowsServiceAccount account;
    public final String host;
    private static final Logger JINTEROP_LOGGER = Logger.getLogger("org.jinterop");

    public ManagedWindowsServiceLauncher(String userName, String password) {
        this(userName, password, null);
    }

    public ManagedWindowsServiceLauncher(String userName, String password, String host) {
        this(userName, password, host, null, null);
    }

    public ManagedWindowsServiceLauncher(String userName, String password, String host, AccountInfo account) {
        this(userName, password, host, account == null ? new ManagedWindowsServiceAccount.LocalSystem() : new ManagedWindowsServiceAccount.AnotherUser(account.userName, account.password), null);
    }

    public ManagedWindowsServiceLauncher(String userName, String password, String host, ManagedWindowsServiceAccount account, String vmargs) {
        this(userName, password, host, account, vmargs, "");
    }

    @DataBoundConstructor
    public ManagedWindowsServiceLauncher(String userName, String password, String host, ManagedWindowsServiceAccount account, String vmargs, String javaPath) {
        this.userName = userName;
        this.password = Secret.fromString((String)password);
        this.vmargs = Util.fixEmptyAndTrim((String)vmargs);
        this.javaPath = Util.fixEmptyAndTrim((String)javaPath);
        this.host = Util.fixEmptyAndTrim((String)host);
        this.account = account == null ? new ManagedWindowsServiceAccount.LocalSystem() : account;
        this.logOn = null;
    }

    public Object readResolve() {
        if (this.logOn != null) {
            this.account = new ManagedWindowsServiceAccount.AnotherUser(this.logOn.userName, this.logOn.password);
        }
        return this;
    }

    private JIDefaultAuthInfoImpl createAuth() {
        String[] tokens = this.userName.split("\\\\");
        if (tokens.length == 2) {
            return new JIDefaultAuthInfoImpl(tokens[0], tokens[1], Secret.toString((Secret)this.password));
        }
        return new JIDefaultAuthInfoImpl("", this.userName, Secret.toString((Secret)this.password));
    }

    private NtlmPasswordAuthentication createSmbAuth() {
        JIDefaultAuthInfoImpl auth = this.createAuth();
        return new NtlmPasswordAuthentication(auth.getDomain(), auth.getUserName(), auth.getPassword());
    }

    public ManagedWindowsServiceAccount getAccount() {
        return this.account;
    }

    private AccountInfo getLogOn() {
        if (this.account == null) {
            return null;
        }
        return this.account.getAccount(this);
    }

    public void launch(final SlaveComputer computer, final TaskListener listener) throws IOException, InterruptedException {
        try {
            PrintStream logger = listener.getLogger();
            String name = this.determineHost((Computer)computer);
            logger.println(Messages.ManagedWindowsServiceLauncher_ConnectingTo(this.getTimestamp(), name));
            InetAddress host = InetAddress.getByName(name);
            this.checkPort135Access(logger, name, host);
            JIDefaultAuthInfoImpl auth = this.createAuth();
            JISession session = JISession.createSession((IJIAuthInfo)auth);
            session.setGlobalSocketTimeout(60000);
            SWbemServices services = WMI.connect((JISession)session, (String)name);
            Slave node = computer.getNode();
            if (node == null) {
                throw new AbortException("Error retrieving node. Node might have been removed");
            }
            String path = node.getRemoteFS();
            if (path.indexOf(58) == -1) {
                throw new IOException("Remote file system root path of the slave needs to be absolute: " + path);
            }
            SmbFile remoteRoot = new SmbFile("smb://" + name + "/" + path.replace('\\', '/').replace(':', '$') + "/", this.createSmbAuth());
            if (!remoteRoot.exists()) {
                remoteRoot.mkdirs();
            }
            String java = this.resolveJava(computer);
            try {
                logger.println("Checking if Java exists");
                WindowsRemoteProcessLauncher wrpl = new WindowsRemoteProcessLauncher(name, (IJIAuthInfo)auth);
                Process proc = wrpl.launch("\"" + java + "\" -version", "c:\\");
                proc.getOutputStream().close();
                StringWriter console = new StringWriter();
                hudson.util.IOUtils.copy((InputStream)proc.getInputStream(), (Writer)console);
                proc.getInputStream().close();
                int exitCode = proc.waitFor();
                if (exitCode == 1) {
                    logger.println("No Java found. Downloading JDK");
                    JDKInstaller jdki = new JDKInstaller("jdk-6u16-oth-JPR@CDS-CDS_Developer", true);
                    URL jdk = jdki.locate(listener, JDKInstaller.Platform.WINDOWS, JDKInstaller.CPU.i386);
                    listener.getLogger().println("Installing JDK");
                    Util.copyStreamAndClose((InputStream)jdk.openStream(), (OutputStream)new SmbFile(remoteRoot, "jdk.exe").getOutputStream());
                    String javaDir = path + "\\jdk";
                    WindowsRemoteFileSystem fs = new WindowsRemoteFileSystem(name, this.createSmbAuth());
                    fs.mkdirs(javaDir);
                    jdki.install((Launcher)new WindowsRemoteLauncher(listener, wrpl), JDKInstaller.Platform.WINDOWS, (JDKInstaller.FileSystem)fs, listener, javaDir, path + "\\jdk.exe");
                } else {
                    ManagedWindowsServiceLauncher.checkJavaVersion((PrintStream)logger, (String)java, (BufferedReader)new BufferedReader(new StringReader(console.toString())));
                }
            }
            catch (Exception e) {
                e.printStackTrace(listener.error("Failed to prepare Java"));
                return;
            }
            String id = this.generateServiceId(path);
            Win32Service slaveService = services.getService(id);
            if (slaveService == null) {
                logger.println(Messages.ManagedWindowsServiceLauncher_InstallingSlaveService(this.getTimestamp()));
                if (!DotNet.isInstalled((int)2, (int)0, (String)name, (IJIAuthInfo)auth)) {
                    logger.println(Messages.ManagedWindowsServiceLauncher_DotNetRequired(this.getTimestamp()));
                    return;
                }
                logger.println(Messages.ManagedWindowsServiceLauncher_CopyingSlaveExe(this.getTimestamp()));
                Util.copyStreamAndClose((InputStream)((Object)((Object)this)).getClass().getResource("/windows-service/jenkins.exe").openStream(), (OutputStream)new SmbFile(remoteRoot, "jenkins-slave.exe").getOutputStream());
                Util.copyStreamAndClose((InputStream)((Object)((Object)this)).getClass().getResource("/windows-service/jenkins.exe.config").openStream(), (OutputStream)new SmbFile(remoteRoot, "jenkins-slave.exe.config").getOutputStream());
                this.copySlaveJar(logger, remoteRoot);
                String xml = this.createAndCopyJenkinsSlaveXml(java, id, logger, remoteRoot);
                logger.println(Messages.ManagedWindowsServiceLauncher_RegisteringService(this.getTimestamp()));
                Document dom = new SAXReader().read((Reader)new StringReader(xml));
                Win32Service svc = (Win32Service)services.Get("Win32_Service").cast(Win32Service.class);
                AccountInfo logOn = this.getLogOn();
                int r = logOn == null ? svc.Create(id, dom.selectSingleNode("/service/name").getText() + " at " + path, path + "\\jenkins-slave.exe", 16, 0, "Manual", true) : svc.Create(id, dom.selectSingleNode("/service/name").getText() + " at " + path, path + "\\jenkins-slave.exe", 16, 0, "Manual", false, logOn.userName, Secret.toString((Secret)logOn.password), null, null, null);
                if (r != 0) {
                    listener.error("Failed to create a service: " + svc.getErrorMessage(r));
                    return;
                }
                slaveService = services.getService(id);
            } else {
                this.createAndCopyJenkinsSlaveXml(java, id, logger, remoteRoot);
                this.copySlaveJar(logger, remoteRoot);
            }
            logger.println(Messages.ManagedWindowsServiceLauncher_StartingService(this.getTimestamp()));
            slaveService.start();
            logger.println(Messages.ManagedWindowsServiceLauncher_WaitingForService(this.getTimestamp()));
            SmbFile portFile = new SmbFile(remoteRoot, "port.txt");
            int i = 0;
            while (!portFile.exists()) {
                if (i >= 30) {
                    listener.error(Messages.ManagedWindowsServiceLauncher_ServiceDidntRespond(this.getTimestamp()));
                    return;
                }
                Thread.sleep(1000L);
                ++i;
            }
            int p = this.readSmbFile(portFile);
            logger.println(Messages.ManagedWindowsServiceLauncher_ConnectingToPort(this.getTimestamp(), p));
            Socket s = new Socket(name, p);
            computer.setChannel((InputStream)new BufferedInputStream((InputStream)new SocketInputStream(s)), (OutputStream)new BufferedOutputStream((OutputStream)new SocketOutputStream(s)), (OutputStream)listener.getLogger(), new Channel.Listener(){

                public void onClosed(Channel channel, IOException cause) {
                    ManagedWindowsServiceLauncher.this.afterDisconnect(computer, listener);
                }
            });
            JISession.destroySession((JISession)session);
        }
        catch (UnknownHostException e) {
            listener.error(Messages.ManagedWindowsServiceLauncher_UnknownHost(this.getTimestamp(), e.getMessage()));
        }
        catch (SmbException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        catch (JIException e) {
            if (e.getErrorCode() == 5) {
                e.printStackTrace(listener.error(Messages.ManagedWindowsServiceLauncher_AccessDenied(this.getTimestamp())));
            } else {
                e.printStackTrace(listener.error(e.getMessage()));
            }
        }
        catch (DocumentException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
    }

    private String resolveJava(SlaveComputer computer) throws AbortException {
        if (StringUtils.isNotBlank((String)this.javaPath)) {
            return this.getEnvVars(computer).expand(this.javaPath);
        }
        return "java";
    }

    private EnvVars getEnvVars(SlaveComputer computer) throws AbortException {
        Slave node = computer.getNode();
        EnvVars local = node != null ? this.getEnvVars((Node)node) : null;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            EnvVars global = this.getEnvVars((Node)jenkins);
            if (global != null) {
                if (local != null) {
                    EnvVars merged = new EnvVars(global);
                    merged.overrideAll((Map)local);
                    return merged;
                }
                return global;
            }
            if (local != null) {
                return local;
            }
        } else {
            throw new AbortException("Jenkins is shut down, no agent will be launched.");
        }
        return new EnvVars();
    }

    private EnvVars getEnvVars(Node n) {
        return this.getEnvVars(n.getNodeProperties());
    }

    private EnvVars getEnvVars(DescribableList<NodeProperty<?>, NodePropertyDescriptor> dl) {
        EnvironmentVariablesNodeProperty evnp = (EnvironmentVariablesNodeProperty)dl.get(EnvironmentVariablesNodeProperty.class);
        if (evnp == null) {
            return null;
        }
        return evnp.getEnvVars();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPort135Access(PrintStream logger, String name, InetAddress host) throws IOException {
        Socket s = new Socket();
        try {
            s.connect(new InetSocketAddress(host, 135), 5000);
        }
        catch (IOException e) {
            logger.println("Failed to connect to port 135 of " + name + ". Is Windows firewall blocking this port? Or did you disable DCOM service?");
        }
        finally {
            s.close();
        }
    }

    protected String determineHost(Computer c) {
        if (StringUtils.isBlank((String)this.host)) {
            return c.getName();
        }
        return this.host;
    }

    private String createAndCopyJenkinsSlaveXml(String java, String serviceId, PrintStream logger, SmbFile remoteRoot) throws IOException {
        logger.println(Messages.ManagedWindowsServiceLauncher_CopyingSlaveXml(this.getTimestamp()));
        String xml = this.generateSlaveXml(serviceId, java + "w.exe", this.vmargs, "-tcp %BASE%\\port.txt");
        Util.copyStreamAndClose((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")), (OutputStream)new SmbFile(remoteRoot, "jenkins-slave.xml").getOutputStream());
        return xml;
    }

    private void copySlaveJar(PrintStream logger, SmbFile remoteRoot) throws IOException {
        logger.println(Messages.ManagedWindowsServiceLauncher_CopyingSlaveJar(this.getTimestamp()));
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new AbortException("Unable to copy slave JAR. Jenkins has not yet been started.");
        }
        Util.copyStreamAndClose((InputStream)jenkins.getJnlpJars("slave.jar").getURL().openStream(), (OutputStream)new SmbFile(remoteRoot, "slave.jar").getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readSmbFile(SmbFile f) throws IOException {
        InputStream in = null;
        try {
            in = f.getInputStream();
            int n = Integer.parseInt(hudson.util.IOUtils.toString((InputStream)in));
            return n;
        }
        finally {
            hudson.util.IOUtils.closeQuietly((InputStream)in);
        }
    }

    public void afterDisconnect(SlaveComputer computer, TaskListener listener) {
        try {
            JIDefaultAuthInfoImpl auth = this.createAuth();
            JISession session = JISession.createSession((IJIAuthInfo)auth);
            session.setGlobalSocketTimeout(60000);
            SWbemServices services = WMI.connect((JISession)session, (String)this.determineHost((Computer)computer));
            Slave node = computer.getNode();
            if (node != null) {
                String id = this.generateServiceId(node.getRemoteFS());
                Win32Service slaveService = services.getService(id);
                if (slaveService != null) {
                    listener.getLogger().println(Messages.ManagedWindowsServiceLauncher_StoppingService(this.getTimestamp()));
                    slaveService.StopService();
                    listener.getLogger().println(Messages.ManagedWindowsServiceLauncher_UnregisteringService(this.getTimestamp()));
                    slaveService.Delete();
                }
            } else {
                throw new AbortException("Node might have been already removed, skipping afterDisconnect logic.");
            }
            JISession.destroySession((JISession)session);
        }
        catch (UnknownHostException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        catch (JIException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        catch (IOException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
    }

    String generateServiceId(String slaveRoot) throws IOException {
        return "jenkinsslave-" + slaveRoot.replace(':', '_').replace('\\', '_').replace('/', '_');
    }

    String generateSlaveXml(String id, String java, String vmargs, String args) throws IOException {
        String xml = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/windows-service/jenkins-slave.xml"), (String)"UTF-8");
        xml = xml.replace("@ID@", id);
        xml = xml.replace("@JAVA@", java);
        xml = xml.replace("@VMARGS@", StringUtils.defaultString((String)vmargs));
        xml = xml.replace("@ARGS@", args);
        return xml;
    }

    protected String getTimestamp() {
        return String.format("[%1$tF %1$tT]", new Date());
    }

    static {
        JINTEROP_LOGGER.setLevel(Level.WARNING);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        public String getDisplayName() {
            return Messages.ManagedWindowsServiceLauncher_DisplayName();
        }
    }

    public static class AccountInfo
    extends AbstractDescribableImpl<AccountInfo> {
        public final String userName;
        public final Secret password;

        @DataBoundConstructor
        public AccountInfo(String userName, String password) {
            this.userName = userName;
            this.password = Secret.fromString((String)password);
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<AccountInfo> {
            public String getDisplayName() {
                return "";
            }
        }
    }
}

