/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.DNSCache;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSListener;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.DNSStatefulObject;
import javax.jmdns.impl.HostInfo;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceEventImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceInfoImpl
extends ServiceInfo
implements DNSListener,
DNSStatefulObject {
    private static Logger logger = Logger.getLogger(ServiceInfoImpl.class.getName());
    private String _domain;
    private String _protocol;
    private String _application;
    private String _name;
    private String _subtype;
    private String _server;
    private int _port;
    private int _weight;
    private int _priority;
    private byte[] _text;
    private Map<String, byte[]> _props;
    private final Set<Inet4Address> _ipv4Addresses;
    private final Set<Inet6Address> _ipv6Addresses;
    private transient String _key;
    private boolean _persistent;
    private boolean _needTextAnnouncing;
    private final ServiceInfoState _state;
    private Delegate _delegate;

    public ServiceInfoImpl(String type, String name, String subtype, int port, int weight, int priority, boolean persistent, String text) {
        this(ServiceInfoImpl.decodeQualifiedNameMap(type, name, subtype), port, weight, priority, persistent, (byte[])null);
        this._server = text;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(text.length());
            ServiceInfoImpl.writeUTF(out, text);
            this._text = out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception: " + e);
        }
    }

    public ServiceInfoImpl(String type, String name, String subtype, int port, int weight, int priority, boolean persistent, Map<String, ?> props) {
        this(ServiceInfoImpl.decodeQualifiedNameMap(type, name, subtype), port, weight, priority, persistent, ServiceInfoImpl.textFromProperties(props));
    }

    public ServiceInfoImpl(String type, String name, String subtype, int port, int weight, int priority, boolean persistent, byte[] text) {
        this(ServiceInfoImpl.decodeQualifiedNameMap(type, name, subtype), port, weight, priority, persistent, text);
    }

    public ServiceInfoImpl(Map<ServiceInfo.Fields, String> qualifiedNameMap, int port, int weight, int priority, boolean persistent, Map<String, ?> props) {
        this(qualifiedNameMap, port, weight, priority, persistent, ServiceInfoImpl.textFromProperties(props));
    }

    ServiceInfoImpl(Map<ServiceInfo.Fields, String> qualifiedNameMap, int port, int weight, int priority, boolean persistent, String text) {
        this(qualifiedNameMap, port, weight, priority, persistent, (byte[])null);
        this._server = text;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(text.length());
            ServiceInfoImpl.writeUTF(out, text);
            this._text = out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception: " + e);
        }
    }

    ServiceInfoImpl(Map<ServiceInfo.Fields, String> qualifiedNameMap, int port, int weight, int priority, boolean persistent, byte[] text) {
        Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.checkQualifiedNameMap(qualifiedNameMap);
        this._domain = map.get((Object)ServiceInfo.Fields.Domain);
        this._protocol = map.get((Object)ServiceInfo.Fields.Protocol);
        this._application = map.get((Object)ServiceInfo.Fields.Application);
        this._name = map.get((Object)ServiceInfo.Fields.Instance);
        this._subtype = map.get((Object)ServiceInfo.Fields.Subtype);
        this._port = port;
        this._weight = weight;
        this._priority = priority;
        this._text = text;
        this.setNeedTextAnnouncing(false);
        this._state = new ServiceInfoState(this);
        this._persistent = persistent;
        this._ipv4Addresses = Collections.synchronizedSet(new LinkedHashSet());
        this._ipv6Addresses = Collections.synchronizedSet(new LinkedHashSet());
    }

    ServiceInfoImpl(ServiceInfo info) {
        this._ipv4Addresses = Collections.synchronizedSet(new LinkedHashSet());
        this._ipv6Addresses = Collections.synchronizedSet(new LinkedHashSet());
        if (info != null) {
            Inet4Address[] ipv4Addresses;
            Inet6Address[] ipv6Addresses;
            this._domain = info.getDomain();
            this._protocol = info.getProtocol();
            this._application = info.getApplication();
            this._name = info.getName();
            this._subtype = info.getSubtype();
            this._port = info.getPort();
            this._weight = info.getWeight();
            this._priority = info.getPriority();
            this._text = info.getTextBytes();
            this._persistent = info.isPersistent();
            for (Inet6Address address : ipv6Addresses = info.getInet6Addresses()) {
                this._ipv6Addresses.add(address);
            }
            for (Inet4Address address : ipv4Addresses = info.getInet4Addresses()) {
                this._ipv4Addresses.add(address);
            }
        }
        this._state = new ServiceInfoState(this);
    }

    public static Map<ServiceInfo.Fields, String> decodeQualifiedNameMap(String type, String name, String subtype) {
        Map<ServiceInfo.Fields, String> qualifiedNameMap = ServiceInfoImpl.decodeQualifiedNameMapForType(type);
        qualifiedNameMap.put(ServiceInfo.Fields.Instance, name);
        qualifiedNameMap.put(ServiceInfo.Fields.Subtype, subtype);
        return ServiceInfoImpl.checkQualifiedNameMap(qualifiedNameMap);
    }

    public static Map<ServiceInfo.Fields, String> decodeQualifiedNameMapForType(String type) {
        String aType;
        String casePreservedType = type;
        String application = aType = type.toLowerCase();
        String protocol = "";
        String subtype = "";
        String name = "";
        String domain = "";
        if (aType.contains("in-addr.arpa") || aType.contains("ip6.arpa")) {
            int index = aType.contains("in-addr.arpa") ? aType.indexOf("in-addr.arpa") : aType.indexOf("ip6.arpa");
            name = ServiceInfoImpl.removeSeparators(casePreservedType.substring(0, index));
            domain = casePreservedType.substring(index);
            application = "";
        } else if (!aType.contains("_") && aType.contains(".")) {
            int index = aType.indexOf(46);
            name = ServiceInfoImpl.removeSeparators(casePreservedType.substring(0, index));
            domain = ServiceInfoImpl.removeSeparators(casePreservedType.substring(index));
            application = "";
        } else {
            int end;
            int start;
            int index;
            if ((!aType.startsWith("_") || aType.startsWith("_services")) && (index = aType.indexOf(46)) > 0) {
                name = casePreservedType.substring(0, index);
                if (index + 1 < aType.length()) {
                    aType = aType.substring(index + 1);
                    casePreservedType = casePreservedType.substring(index + 1);
                }
            }
            if ((index = aType.lastIndexOf("._")) > 0) {
                start = index + 2;
                end = aType.indexOf(46, start);
                protocol = casePreservedType.substring(start, end);
            }
            if (protocol.length() > 0) {
                index = aType.indexOf("_" + protocol.toLowerCase() + ".");
                start = index + protocol.length() + 2;
                end = aType.length() - (aType.endsWith(".") ? 1 : 0);
                domain = casePreservedType.substring(start, end);
                application = casePreservedType.substring(0, index - 1);
            }
            if ((index = application.toLowerCase().indexOf("._sub")) > 0) {
                start = index + 5;
                subtype = ServiceInfoImpl.removeSeparators(application.substring(0, index));
                application = application.substring(start);
            }
        }
        HashMap<ServiceInfo.Fields, String> qualifiedNameMap = new HashMap<ServiceInfo.Fields, String>(5);
        qualifiedNameMap.put(ServiceInfo.Fields.Domain, ServiceInfoImpl.removeSeparators(domain));
        qualifiedNameMap.put(ServiceInfo.Fields.Protocol, protocol);
        qualifiedNameMap.put(ServiceInfo.Fields.Application, ServiceInfoImpl.removeSeparators(application));
        qualifiedNameMap.put(ServiceInfo.Fields.Instance, name);
        qualifiedNameMap.put(ServiceInfo.Fields.Subtype, subtype);
        return qualifiedNameMap;
    }

    protected static Map<ServiceInfo.Fields, String> checkQualifiedNameMap(Map<ServiceInfo.Fields, String> qualifiedNameMap) {
        String subtype;
        String instance;
        String application;
        String protocol;
        String domain;
        HashMap<ServiceInfo.Fields, String> checkedQualifiedNameMap = new HashMap<ServiceInfo.Fields, String>(5);
        String string = domain = qualifiedNameMap.containsKey((Object)ServiceInfo.Fields.Domain) ? qualifiedNameMap.get((Object)ServiceInfo.Fields.Domain) : "local";
        if (domain == null || domain.length() == 0) {
            domain = "local";
        }
        domain = ServiceInfoImpl.removeSeparators(domain);
        checkedQualifiedNameMap.put(ServiceInfo.Fields.Domain, domain);
        String string2 = protocol = qualifiedNameMap.containsKey((Object)ServiceInfo.Fields.Protocol) ? qualifiedNameMap.get((Object)ServiceInfo.Fields.Protocol) : "tcp";
        if (protocol == null || protocol.length() == 0) {
            protocol = "tcp";
        }
        protocol = ServiceInfoImpl.removeSeparators(protocol);
        checkedQualifiedNameMap.put(ServiceInfo.Fields.Protocol, protocol);
        String string3 = application = qualifiedNameMap.containsKey((Object)ServiceInfo.Fields.Application) ? qualifiedNameMap.get((Object)ServiceInfo.Fields.Application) : "";
        if (application == null || application.length() == 0) {
            application = "";
        }
        application = ServiceInfoImpl.removeSeparators(application);
        checkedQualifiedNameMap.put(ServiceInfo.Fields.Application, application);
        String string4 = instance = qualifiedNameMap.containsKey((Object)ServiceInfo.Fields.Instance) ? qualifiedNameMap.get((Object)ServiceInfo.Fields.Instance) : "";
        if (instance == null || instance.length() == 0) {
            instance = "";
        }
        instance = ServiceInfoImpl.removeSeparators(instance);
        checkedQualifiedNameMap.put(ServiceInfo.Fields.Instance, instance);
        String string5 = subtype = qualifiedNameMap.containsKey((Object)ServiceInfo.Fields.Subtype) ? qualifiedNameMap.get((Object)ServiceInfo.Fields.Subtype) : "";
        if (subtype == null || subtype.length() == 0) {
            subtype = "";
        }
        subtype = ServiceInfoImpl.removeSeparators(subtype);
        checkedQualifiedNameMap.put(ServiceInfo.Fields.Subtype, subtype);
        return checkedQualifiedNameMap;
    }

    private static String removeSeparators(String name) {
        if (name == null) {
            return "";
        }
        String newName = name.trim();
        if (newName.startsWith(".")) {
            newName = newName.substring(1);
        }
        if (newName.startsWith("_")) {
            newName = newName.substring(1);
        }
        if (newName.endsWith(".")) {
            newName = newName.substring(0, newName.length() - 1);
        }
        return newName;
    }

    @Override
    public String getType() {
        String domain = this.getDomain();
        String protocol = this.getProtocol();
        String application = this.getApplication();
        return (application.length() > 0 ? "_" + application + "." : "") + (protocol.length() > 0 ? "_" + protocol + "." : "") + domain + ".";
    }

    @Override
    public String getTypeWithSubtype() {
        String subtype = this.getSubtype();
        return (subtype.length() > 0 ? "_" + subtype.toLowerCase() + "._sub." : "") + this.getType();
    }

    @Override
    public String getName() {
        return this._name != null ? this._name : "";
    }

    @Override
    public String getKey() {
        if (this._key == null) {
            this._key = this.getQualifiedName().toLowerCase();
        }
        return this._key;
    }

    void setName(String name) {
        this._name = name;
        this._key = null;
    }

    @Override
    public String getQualifiedName() {
        String domain = this.getDomain();
        String protocol = this.getProtocol();
        String application = this.getApplication();
        String instance = this.getName();
        return (instance.length() > 0 ? instance + "." : "") + (application.length() > 0 ? "_" + application + "." : "") + (protocol.length() > 0 ? "_" + protocol + "." : "") + domain + ".";
    }

    @Override
    public String getServer() {
        return this._server != null ? this._server : "";
    }

    void setServer(String server) {
        this._server = server;
    }

    @Override
    @Deprecated
    public String getHostAddress() {
        String[] names = this.getHostAddresses();
        return names.length > 0 ? names[0] : "";
    }

    @Override
    public String[] getHostAddresses() {
        InetAddress[] addresses = this.getInetAddresses();
        String[] names = new String[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            names[i] = addresses[i].getHostAddress();
        }
        return names;
    }

    void addAddress(Inet4Address addr) {
        this._ipv4Addresses.add(addr);
    }

    void addAddress(Inet6Address addr) {
        this._ipv6Addresses.add(addr);
    }

    @Override
    @Deprecated
    public InetAddress getAddress() {
        return this.getInetAddress();
    }

    @Override
    @Deprecated
    public InetAddress getInetAddress() {
        InetAddress[] addresses = this.getInetAddresses();
        return addresses.length > 0 ? addresses[0] : null;
    }

    @Override
    @Deprecated
    public Inet4Address getInet4Address() {
        Inet4Address[] addresses = this.getInet4Addresses();
        return addresses.length > 0 ? addresses[0] : null;
    }

    @Override
    @Deprecated
    public Inet6Address getInet6Address() {
        Inet6Address[] addresses = this.getInet6Addresses();
        return addresses.length > 0 ? addresses[0] : null;
    }

    @Override
    public InetAddress[] getInetAddresses() {
        ArrayList<InetAddress> aList = new ArrayList<InetAddress>(this._ipv4Addresses.size() + this._ipv6Addresses.size());
        aList.addAll(this._ipv4Addresses);
        aList.addAll(this._ipv6Addresses);
        return aList.toArray(new InetAddress[aList.size()]);
    }

    @Override
    public Inet4Address[] getInet4Addresses() {
        return this._ipv4Addresses.toArray(new Inet4Address[this._ipv4Addresses.size()]);
    }

    @Override
    public Inet6Address[] getInet6Addresses() {
        return this._ipv6Addresses.toArray(new Inet6Address[this._ipv6Addresses.size()]);
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public int getPriority() {
        return this._priority;
    }

    @Override
    public int getWeight() {
        return this._weight;
    }

    @Override
    public byte[] getTextBytes() {
        return this._text != null && this._text.length > 0 ? this._text : DNSRecord.EMPTY_TXT;
    }

    @Override
    @Deprecated
    public String getTextString() {
        Map<String, byte[]> properties = this.getProperties();
        Iterator<String> i$ = properties.keySet().iterator();
        if (i$.hasNext()) {
            String key = i$.next();
            byte[] value = properties.get(key);
            if (value != null && value.length > 0) {
                return key + "=" + new String(value);
            }
            return key;
        }
        return "";
    }

    @Override
    @Deprecated
    public String getURL() {
        return this.getURL("http");
    }

    @Override
    public String[] getURLs() {
        return this.getURLs("http");
    }

    @Override
    @Deprecated
    public String getURL(String protocol) {
        String[] urls = this.getURLs(protocol);
        return urls.length > 0 ? urls[0] : protocol + "://null:" + this.getPort();
    }

    @Override
    public String[] getURLs(String protocol) {
        InetAddress[] addresses = this.getInetAddresses();
        String[] urls = new String[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            String url = protocol + "://" + addresses[i].getHostAddress() + ":" + this.getPort();
            String path = this.getPropertyString("path");
            if (path != null) {
                url = path.indexOf("://") >= 0 ? path : url + (path.startsWith("/") ? path : "/" + path);
            }
            urls[i] = url;
        }
        return urls;
    }

    @Override
    public synchronized byte[] getPropertyBytes(String name) {
        return this.getProperties().get(name);
    }

    @Override
    public synchronized String getPropertyString(String name) {
        byte[] data = this.getProperties().get(name);
        if (data == null) {
            return null;
        }
        if (data == NO_VALUE) {
            return "true";
        }
        return this.readUTF(data, 0, data.length);
    }

    @Override
    public Enumeration<String> getPropertyNames() {
        Map<String, byte[]> properties = this.getProperties();
        Set<Object> names = properties != null ? properties.keySet() : Collections.emptySet();
        return new Vector(names).elements();
    }

    @Override
    public String getApplication() {
        return this._application != null ? this._application : "";
    }

    @Override
    public String getDomain() {
        return this._domain != null ? this._domain : "local";
    }

    @Override
    public String getProtocol() {
        return this._protocol != null ? this._protocol : "tcp";
    }

    @Override
    public String getSubtype() {
        return this._subtype != null ? this._subtype : "";
    }

    @Override
    public Map<ServiceInfo.Fields, String> getQualifiedNameMap() {
        HashMap<ServiceInfo.Fields, String> map = new HashMap<ServiceInfo.Fields, String>(5);
        map.put(ServiceInfo.Fields.Domain, this.getDomain());
        map.put(ServiceInfo.Fields.Protocol, this.getProtocol());
        map.put(ServiceInfo.Fields.Application, this.getApplication());
        map.put(ServiceInfo.Fields.Instance, this.getName());
        map.put(ServiceInfo.Fields.Subtype, this.getSubtype());
        return map;
    }

    static void writeUTF(OutputStream out, String str) throws IOException {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                out.write(c);
                continue;
            }
            if (c > '\u07ff') {
                out.write(0xE0 | c >> 12 & 0xF);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            out.write(0xC0 | c >> 6 & 0x1F);
            out.write(0x80 | c >> 0 & 0x3F);
        }
    }

    String readUTF(byte[] data, int off, int len) {
        int offset = off;
        StringBuffer buf = new StringBuffer();
        int end = offset + len;
        while (offset < end) {
            int ch = data[offset++] & 0xFF;
            switch (ch >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 12: 
                case 13: {
                    if (offset >= len) {
                        return null;
                    }
                    ch = (ch & 0x1F) << 6 | data[offset++] & 0x3F;
                    break;
                }
                case 14: {
                    if (offset + 2 >= len) {
                        return null;
                    }
                    ch = (ch & 0xF) << 12 | (data[offset++] & 0x3F) << 6 | data[offset++] & 0x3F;
                    break;
                }
                default: {
                    if (offset + 1 >= len) {
                        return null;
                    }
                    ch = (ch & 0x3F) << 4 | data[offset++] & 0xF;
                }
            }
            buf.append((char)ch);
        }
        return buf.toString();
    }

    synchronized Map<String, byte[]> getProperties() {
        if (this._props == null && this.getTextBytes() != null) {
            Hashtable<String, byte[]> properties = new Hashtable<String, byte[]>();
            try {
                int off = 0;
                while (off < this.getTextBytes().length) {
                    int i;
                    int len = this.getTextBytes()[off++] & 0xFF;
                    if (len == 0 || off + len > this.getTextBytes().length) {
                        properties.clear();
                        break;
                    }
                    for (i = 0; i < len && this.getTextBytes()[off + i] != 61; ++i) {
                    }
                    String name = this.readUTF(this.getTextBytes(), off, i);
                    if (name == null) {
                        properties.clear();
                        break;
                    }
                    if (i == len) {
                        properties.put(name, NO_VALUE);
                        continue;
                    }
                    byte[] value = new byte[len - ++i];
                    System.arraycopy(this.getTextBytes(), off + i, value, 0, len - i);
                    properties.put(name, value);
                    off += len;
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Malformed TXT Field ", exception);
            }
            this._props = properties;
        }
        return this._props != null ? this._props : Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(DNSCache dnsCache, long now, DNSEntry rec) {
        if (rec instanceof DNSRecord && !rec.isExpired(now)) {
            JmDNSImpl dns;
            boolean serviceUpdated = false;
            switch (rec.getRecordType()) {
                case TYPE_A: {
                    if (!rec.getName().equalsIgnoreCase(this.getServer())) break;
                    this._ipv4Addresses.add((Inet4Address)((DNSRecord.Address)rec).getAddress());
                    serviceUpdated = true;
                    break;
                }
                case TYPE_AAAA: {
                    if (!rec.getName().equalsIgnoreCase(this.getServer())) break;
                    this._ipv6Addresses.add((Inet6Address)((DNSRecord.Address)rec).getAddress());
                    serviceUpdated = true;
                    break;
                }
                case TYPE_SRV: {
                    if (!rec.getName().equalsIgnoreCase(this.getQualifiedName())) break;
                    DNSRecord.Service srv = (DNSRecord.Service)rec;
                    boolean serverChanged = this._server == null || !this._server.equalsIgnoreCase(srv.getServer());
                    this._server = srv.getServer();
                    this._port = srv.getPort();
                    this._weight = srv.getWeight();
                    this._priority = srv.getPriority();
                    if (serverChanged) {
                        this._ipv4Addresses.clear();
                        this._ipv6Addresses.clear();
                        for (DNSEntry dNSEntry : dnsCache.getDNSEntryList(this._server, DNSRecordType.TYPE_A, DNSRecordClass.CLASS_IN)) {
                            this.updateRecord(dnsCache, now, dNSEntry);
                        }
                        for (DNSEntry dNSEntry : dnsCache.getDNSEntryList(this._server, DNSRecordType.TYPE_AAAA, DNSRecordClass.CLASS_IN)) {
                            this.updateRecord(dnsCache, now, dNSEntry);
                        }
                        break;
                    }
                    serviceUpdated = true;
                    break;
                }
                case TYPE_TXT: {
                    if (!rec.getName().equalsIgnoreCase(this.getQualifiedName())) break;
                    DNSRecord.Text txt = (DNSRecord.Text)rec;
                    this._text = txt.getText();
                    serviceUpdated = true;
                    break;
                }
                case TYPE_PTR: {
                    if (this.getSubtype().length() != 0 || rec.getSubtype().length() == 0) break;
                    this._subtype = rec.getSubtype();
                    serviceUpdated = true;
                    break;
                }
            }
            if (serviceUpdated && this.hasData() && (dns = this.getDns()) != null) {
                ServiceEvent event = ((DNSRecord)rec).getServiceEvent(dns);
                event = new ServiceEventImpl(dns, event.getType(), event.getName(), this);
                dns.handleServiceResolved(event);
            }
            ServiceInfoImpl serviceInfoImpl = this;
            synchronized (serviceInfoImpl) {
                this.notifyAll();
            }
        }
    }

    @Override
    public synchronized boolean hasData() {
        return this.getServer() != null && this.hasInetAddress() && this.getTextBytes() != null && this.getTextBytes().length > 0;
    }

    private final boolean hasInetAddress() {
        return this._ipv4Addresses.size() > 0 || this._ipv6Addresses.size() > 0;
    }

    @Override
    public boolean advanceState(DNSTask task) {
        return this._state.advanceState(task);
    }

    @Override
    public boolean revertState() {
        return this._state.revertState();
    }

    @Override
    public boolean cancelState() {
        return this._state.cancelState();
    }

    @Override
    public boolean closeState() {
        return this._state.closeState();
    }

    @Override
    public boolean recoverState() {
        return this._state.recoverState();
    }

    @Override
    public void removeAssociationWithTask(DNSTask task) {
        this._state.removeAssociationWithTask(task);
    }

    @Override
    public void associateWithTask(DNSTask task, DNSState state) {
        this._state.associateWithTask(task, state);
    }

    @Override
    public boolean isAssociatedWithTask(DNSTask task, DNSState state) {
        return this._state.isAssociatedWithTask(task, state);
    }

    @Override
    public boolean isProbing() {
        return this._state.isProbing();
    }

    @Override
    public boolean isAnnouncing() {
        return this._state.isAnnouncing();
    }

    @Override
    public boolean isAnnounced() {
        return this._state.isAnnounced();
    }

    @Override
    public boolean isCanceling() {
        return this._state.isCanceling();
    }

    @Override
    public boolean isCanceled() {
        return this._state.isCanceled();
    }

    @Override
    public boolean isClosing() {
        return this._state.isClosing();
    }

    @Override
    public boolean isClosed() {
        return this._state.isClosed();
    }

    @Override
    public boolean waitForAnnounced(long timeout) {
        return this._state.waitForAnnounced(timeout);
    }

    @Override
    public boolean waitForCanceled(long timeout) {
        return this._state.waitForCanceled(timeout);
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ServiceInfoImpl && this.getQualifiedName().equals(((ServiceInfoImpl)obj).getQualifiedName());
    }

    @Override
    public String getNiceTextString() {
        StringBuffer buf = new StringBuffer();
        int len = this.getTextBytes().length;
        for (int i = 0; i < len; ++i) {
            if (i >= 200) {
                buf.append("...");
                break;
            }
            int ch = this.getTextBytes()[i] & 0xFF;
            if (ch < 32 || ch > 127) {
                buf.append("\\0");
                buf.append(Integer.toString(ch, 8));
                continue;
            }
            buf.append((char)ch);
        }
        return buf.toString();
    }

    @Override
    public ServiceInfoImpl clone() {
        Inet4Address[] ipv4Addresses;
        Inet6Address[] ipv6Addresses;
        ServiceInfoImpl serviceInfo = new ServiceInfoImpl(this.getQualifiedNameMap(), this._port, this._weight, this._priority, this._persistent, this._text);
        for (Inet6Address address : ipv6Addresses = this.getInet6Addresses()) {
            serviceInfo._ipv6Addresses.add(address);
        }
        for (Inet4Address address : ipv4Addresses = this.getInet4Addresses()) {
            serviceInfo._ipv4Addresses.add(address);
        }
        return serviceInfo;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[" + this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + " ");
        buf.append("name: '");
        buf.append((this.getName().length() > 0 ? this.getName() + "." : "") + this.getTypeWithSubtype());
        buf.append("' address: '");
        InetAddress[] addresses = this.getInetAddresses();
        if (addresses.length > 0) {
            for (InetAddress address : addresses) {
                buf.append(address);
                buf.append(':');
                buf.append(this.getPort());
                buf.append(' ');
            }
        } else {
            buf.append("(null):");
            buf.append(this.getPort());
        }
        buf.append("' status: '");
        buf.append(this._state.toString());
        buf.append(this.isPersistent() ? "' is persistent," : "',");
        buf.append(" has ");
        buf.append(this.hasData() ? "" : "NO ");
        buf.append("data");
        if (this.getTextBytes().length > 0) {
            Map<String, byte[]> properties = this.getProperties();
            if (!properties.isEmpty()) {
                buf.append("\n");
                for (String key : properties.keySet()) {
                    buf.append("\t" + key + ": " + new String(properties.get(key)) + "\n");
                }
            } else {
                buf.append(" empty");
            }
        }
        buf.append(']');
        return buf.toString();
    }

    public Collection<DNSRecord> answers(boolean unique, int ttl, HostInfo localHost) {
        ArrayList<DNSRecord> list = new ArrayList<DNSRecord>();
        if (this.getSubtype().length() > 0) {
            list.add(new DNSRecord.Pointer(this.getTypeWithSubtype(), DNSRecordClass.CLASS_IN, false, ttl, this.getQualifiedName()));
        }
        list.add(new DNSRecord.Pointer(this.getType(), DNSRecordClass.CLASS_IN, false, ttl, this.getQualifiedName()));
        list.add(new DNSRecord.Service(this.getQualifiedName(), DNSRecordClass.CLASS_IN, unique, ttl, this._priority, this._weight, this._port, localHost.getName()));
        list.add(new DNSRecord.Text(this.getQualifiedName(), DNSRecordClass.CLASS_IN, unique, ttl, this.getTextBytes()));
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText(byte[] text) throws IllegalStateException {
        ServiceInfoImpl serviceInfoImpl = this;
        synchronized (serviceInfoImpl) {
            this._text = text;
            this._props = null;
            this.setNeedTextAnnouncing(true);
        }
    }

    @Override
    public void setText(Map<String, ?> props) throws IllegalStateException {
        this.setText(ServiceInfoImpl.textFromProperties(props));
    }

    void _setText(byte[] text) {
        this._text = text;
        this._props = null;
    }

    private static byte[] textFromProperties(Map<String, ?> props) {
        byte[] text = null;
        if (props != null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream(256);
                for (String key : props.keySet()) {
                    byte[] data;
                    Object val = props.get(key);
                    ByteArrayOutputStream out2 = new ByteArrayOutputStream(100);
                    ServiceInfoImpl.writeUTF(out2, key);
                    if (val != null) {
                        if (val instanceof String) {
                            out2.write(61);
                            ServiceInfoImpl.writeUTF(out2, (String)val);
                        } else if (val instanceof byte[]) {
                            byte[] bval = (byte[])val;
                            if (bval.length > 0) {
                                out2.write(61);
                                out2.write(bval, 0, bval.length);
                            } else {
                                val = null;
                            }
                        } else {
                            throw new IllegalArgumentException("invalid property value: " + val);
                        }
                    }
                    if ((data = out2.toByteArray()).length > 255) {
                        throw new IOException("Cannot have individual values larger that 255 chars. Offending value: " + key + (val != null ? "" : "=" + val));
                    }
                    out.write((byte)data.length);
                    out.write(data, 0, data.length);
                }
                text = out.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected exception: " + e);
            }
        }
        return text != null && text.length > 0 ? text : DNSRecord.EMPTY_TXT;
    }

    public void setDns(JmDNSImpl dns) {
        this._state.setDns(dns);
    }

    @Override
    public JmDNSImpl getDns() {
        return this._state.getDns();
    }

    @Override
    public boolean isPersistent() {
        return this._persistent;
    }

    public void setNeedTextAnnouncing(boolean needTextAnnouncing) {
        this._needTextAnnouncing = needTextAnnouncing;
        if (this._needTextAnnouncing) {
            this._state.setTask(null);
        }
    }

    public boolean needTextAnnouncing() {
        return this._needTextAnnouncing;
    }

    Delegate getDelegate() {
        return this._delegate;
    }

    void setDelegate(Delegate delegate) {
        this._delegate = delegate;
    }

    private static final class ServiceInfoState
    extends DNSStatefulObject.DefaultImplementation {
        private static final long serialVersionUID = 1104131034952196820L;
        private final ServiceInfoImpl _info;

        public ServiceInfoState(ServiceInfoImpl info) {
            this._info = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setTask(DNSTask task) {
            super.setTask(task);
            if (this._task == null && this._info.needTextAnnouncing()) {
                this.lock();
                try {
                    if (this._task == null && this._info.needTextAnnouncing()) {
                        if (this._state.isAnnounced()) {
                            this.setState(DNSState.ANNOUNCING_1);
                            if (this.getDns() != null) {
                                this.getDns().startAnnouncer();
                            }
                        }
                        this._info.setNeedTextAnnouncing(false);
                    }
                }
                finally {
                    this.unlock();
                }
            }
        }

        public void setDns(JmDNSImpl dns) {
            super.setDns(dns);
        }
    }

    public static interface Delegate {
        public void textValueUpdated(ServiceInfo var1, byte[] var2);
    }
}

